/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.util.ListIterator;
import shrub.Box;
import shrub.MoveHistory;
import shrub.Movement;

public class HistoricIterator {
    private MoveHistory mHistoryRef = null;
    private int mDirection = -1;
    private int mStartIndex = -1;
    private ListIterator mListIterator = null;
    private boolean mIsOkay = true;
    private Movement mIteratingMove = null;
    private Box mAllowedArea = null;

    public HistoricIterator(MoveHistory historyRef, Movement startMove, Box allowedArea) {
        if (historyRef != null && startMove != null) {
            this.mHistoryRef = historyRef;
            this.mStartIndex = this.mHistoryRef.GetNumMoves();
            this.mDirection = -1;
            this.mListIterator = this.mHistoryRef.listIterator(this.mStartIndex);
            this.mIteratingMove = startMove;
            this.mAllowedArea = allowedArea;
        } else {
            System.out.println("ERROR: HistoricIterator::Constructor, null ref");
            this.mIsOkay = false;
        }
    }

    public HistoricIterator(MoveHistory historyRef, Movement startMove, Box allowedArea, int periodicity) {
        if (historyRef != null && startMove != null) {
            this.mHistoryRef = historyRef;
            int listSize = this.mHistoryRef.GetNumMoves();
            this.mStartIndex = listSize - periodicity;
            this.mDirection = 1;
            if (this.mStartIndex < 0) {
                this.mStartIndex = 0;
            }
            this.mListIterator = this.mHistoryRef.listIterator(this.mStartIndex);
            this.mIteratingMove = startMove;
            this.mAllowedArea = allowedArea;
        } else {
            System.out.println("ERROR: HistoricIterator::Constructor, null ref");
            this.mIsOkay = false;
        }
    }

    public final boolean IsOkay() {
        return this.mIsOkay;
    }

    public Movement getIteratingMove() {
        return this.mIteratingMove;
    }

    public final boolean Iterate() {
        boolean okSoFar = true;
        int listSize = this.mHistoryRef.GetNumMoves();
        Movement histMove = null;
        if (this.mIsOkay && listSize > 0) {
            if (this.mDirection < 0) {
                if (!this.mListIterator.hasPrevious()) {
                    this.mListIterator = this.mHistoryRef.listIterator(this.mStartIndex);
                }
                histMove = (Movement)this.mListIterator.previous();
            } else {
                if (!this.mListIterator.hasNext()) {
                    this.mListIterator = this.mHistoryRef.listIterator(this.mStartIndex);
                }
                histMove = (Movement)this.mListIterator.next();
            }
            long deltaTime = histMove.GetTimeDelta();
            long predictTime = this.mIteratingMove.GetTimeNow() + deltaTime;
            Movement extrapMove = Movement.valueOfExtrapolation(this.mIteratingMove, predictTime, this.mAllowedArea, histMove);
            if (extrapMove == null) {
                okSoFar = false;
                System.out.println("  HI:I : extrapMove == null");
            } else {
                this.mIteratingMove = extrapMove;
            }
        } else {
            System.out.println("ERROR: HistoricIterator::Iterate(), bad state or list empty");
            okSoFar = false;
        }
        return okSoFar;
    }
}

