/*
 * Decompiled with CFR 0.152.
 */
package pulsar;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import pulsar.AbstractManager;
import pulsar.EnemyFireListener;
import pulsar.PulsarMax;
import pulsar.Strategy;
import pulsar.movement.Movement;
import pulsar.util.RobotData;
import pulsar.util.Util;
import pulsar.util.Wave;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

public class MovementManager
extends AbstractManager
implements EnemyFireListener {
    private static Map fireWaves = new HashMap();
    private static Map virtualWaves = new HashMap();
    private Movement currentMovement;
    private long lastTime;
    private static int lastRound = -1;

    public Strategy getBestStrategy(AdvancedRobot robot, RobotData target, Map radar) {
        int best = 0;
        double maxScore = 0.0;
        Strategy[] strategies = this.getStrategies();
        int i = 0;
        while (i < strategies.length) {
            double tmp;
            if (strategies[i].isRealStrategy() && (tmp = strategies[i].getScore(robot, target, radar, fireWaves)) > maxScore) {
                best = i;
                maxScore = tmp;
            }
            ++i;
        }
        return strategies[best];
    }

    public void update(AdvancedRobot robot, RobotData target, Map radar) {
        if (lastRound != robot.getRoundNum()) {
            fireWaves.clear();
            virtualWaves.clear();
        }
        if (this.lastTime != PulsarMax.time && target.dataFromRound == robot.getRoundNum()) {
            Movement newMovement = (Movement)this.getBestStrategy(robot, target, radar);
            if (this.currentMovement != newMovement) {
                this.currentMovement = newMovement;
                PulsarMax.println("Movement changed to: " + this.currentMovement.getName());
            }
            this.currentMovement.doMovement(robot, target, radar, fireWaves);
            this.lastTime = PulsarMax.time;
        }
        lastRound = robot.getRoundNum();
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.currentMovement != null) {
            this.currentMovement.onHitRobot(e);
        }
    }

    public void onHitWall(HitWallEvent e) {
        if (this.currentMovement != null) {
            this.currentMovement.onHitWall(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this.currentMovement != null) {
            this.currentMovement.onBulletHit(e);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.currentMovement != null) {
            this.currentMovement.onHitByBullet(e, fireWaves);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        if (this.currentMovement != null) {
            this.currentMovement.onBulletHitBullet(event, fireWaves);
        }
    }

    public void addWave(RobotData enemy, double firePower) {
        if (Util.getTimeToGunReady(enemy.lastFirePower, PulsarMax.time - (enemy.timeLastFire + (long)1)) > (long)3) {
            PulsarMax.println("Probable false enemy fire detection! Ignoring...");
            return;
        }
        this.addWave(enemy, firePower, false);
    }

    private void addWave(RobotData enemy, double firePower, boolean virtual) {
        Strategy[] strategies = this.getStrategies();
        HashMap segs = new HashMap();
        int i = 0;
        while (i < strategies.length) {
            Map segMap = ((Movement)strategies[i]).getSegmentationMap();
            if (segMap != null) {
                segs.putAll(segMap);
            }
            ++i;
        }
        Wave wave = enemy.createWave(PulsarMax.robotStats, firePower, virtual, segs);
        if (virtual) {
            this.addWave(virtualWaves, enemy, wave);
        } else {
            this.addWave(fireWaves, enemy, wave);
            wave.addWaveGraphics();
        }
    }

    private void addWave(Map waves, RobotData target, Wave wave) {
        LinkedList<Wave> list = (LinkedList<Wave>)waves.get(target.name);
        if (list == null) {
            list = new LinkedList<Wave>();
            waves.put(target.name, list);
        }
        list.add(wave);
    }
}

