/*
 * Decompiled with CFR 0.152.
 */
package nic;

import java.awt.geom.Point2D;
import nic.AccelerationPatternRecogniser;
import nic.BulletStatManager;
import nic.Nicator;
import nic.ShotInfo;

class Enemy {
    String name;
    public double bearing;
    public double heading;
    public double speed;
    public double x;
    public double y;
    public double distance;
    public double changehead;
    public double energy;
    public double maxvelocity = 0.0;
    public long ctime;
    public boolean live;
    public boolean fired;
    double timelastprinted = 0.0;
    double absavgspeed = 0.0;
    double noabsavgspeed = 1.0;
    AccelerationPatternRecogniser apr;
    Nicator rob;

    public Enemy(Nicator pRob) {
        this.rob = pRob;
        this.apr = new AccelerationPatternRecogniser();
    }

    public Point2D.Double guessPosition(long when) {
        if (this.rob.getOthers() == 1) {
            if (Nicator.br.bulletDodging() && this.energy != 0.0) {
                return this.guessHalfLinearPosition(when);
            }
            if (BulletStatManager.enemies.get(this.rob.target.name) != null) {
                ShotInfo si = (ShotInfo)BulletStatManager.enemies.get(this.rob.target.name);
                if (si.bestStrategy() == 0) {
                    return this.guessCircularPosition(when);
                }
                if (si.bestStrategy() == 1) {
                    return this.guessDirectPosition();
                }
                if (si.bestStrategy() == 2) {
                    if ((this.apr.avgreversetime + 2.0) / this.apr.standdev >= 2.0 && this.energy != 0.0 && !Nicator.br.bulletDodging() && this.rob.getTime() > 50L) {
                        return this.guessAccelerationPatternPosition(when);
                    }
                    if (si.bestStandardStrategy() == 0) {
                        return this.guessCircularPosition(when);
                    }
                    return this.guessDirectPosition();
                }
                return new Point2D.Double(0.0, 0.0);
            }
            return new Point2D.Double(0.0, 0.0);
        }
        return this.guessCircularPosition(when);
    }

    public Point2D.Double guessHalfLinearPosition(long when) {
        double diff = when - this.ctime;
        double newY = 0.0;
        double newX = 0.0;
        if (this.distance > 300.0) {
            newY = this.y + Math.cos(this.heading) * this.absavgspeed * diff * Nicator.br.lastdirection;
            newX = this.x + Math.sin(this.heading) * this.absavgspeed * diff * Nicator.br.lastdirection;
        } else {
            newY = this.y + Math.cos(this.heading) * this.absavgspeed * diff * Nicator.br.lastdirection;
            newX = this.x + Math.sin(this.heading) * this.absavgspeed * diff * Nicator.br.lastdirection;
        }
        return new Point2D.Double(newX, newY);
    }

    public Point2D.Double guessDirectPosition() {
        Nicator.fm.lastmovetype = 1;
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Double guessCircularPosition(long when) {
        double newX;
        double newY;
        Nicator.fm.lastmovetype = 0;
        double diff = when - this.ctime;
        if (Math.abs(this.changehead) > 1.0E-5) {
            double radius = this.speed / this.changehead;
            double tothead = diff * this.changehead;
            newY = this.y + Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius;
            newX = this.x + Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius;
        } else {
            newY = this.y + Math.cos(this.heading) * this.speed * diff;
            newX = this.x + Math.sin(this.heading) * this.speed * diff;
        }
        return new Point2D.Double(newX, newY);
    }

    public Point2D.Double guessAccelerationPatternPosition(long when) {
        double currenttime;
        Nicator.fm.lastmovetype = 2;
        boolean print = true;
        if (this.timelastprinted == (double)this.rob.getTime()) {
            print = false;
        } else {
            this.timelastprinted = this.rob.getTime();
        }
        double avgreversetime = Math.round(this.apr.avgreversetime);
        double acceleration = this.apr.acceleration;
        if (acceleration == 0.0) {
            acceleration = Math.abs(this.speed) != 8.0 ? (this.apr.accelerating ? 1.0 : -1.0) : (this.speed == 8.0 ? 1.0 : -1.0);
        }
        if ((currenttime = (double)(this.ctime - this.apr.timelastreverse)) > avgreversetime) {
            acceleration *= -1.0;
        }
        double oldtime = currenttime;
        double velocity = this.speed;
        double avgvelocity = this.speed;
        int novelocities = 0;
        while ((double)this.ctime + currenttime - oldtime < (double)when) {
            if (novelocities == 0) {
                novelocities = 1;
                avgvelocity = velocity;
            } else {
                avgvelocity = (avgvelocity * (double)novelocities + velocity) / (double)(novelocities + 1);
                ++novelocities;
            }
            velocity += acceleration;
            if ((currenttime += 1.0) % avgreversetime == 0.0) {
                acceleration *= -1.0;
            }
            if (velocity > 8.0) {
                velocity = 8.0;
            }
            if (!(velocity < -8.0)) continue;
            velocity = -8.0;
        }
        double diff = when - this.ctime;
        double newY = this.y + Math.cos(this.heading) * avgvelocity * diff;
        double newX = this.x + Math.sin(this.heading) * avgvelocity * diff;
        return new Point2D.Double(newX, newY);
    }
}

