/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.motion;

import eem.frame.bot.fighterBot;
import eem.frame.dangermap.dangerMap;
import eem.frame.dangermap.dangerPath;
import eem.frame.dangermap.dangerPoint;
import eem.frame.misc.graphics;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import eem.frame.misc.profiler;
import eem.frame.motion.basicMotion;
import eem.frame.motion.pathSimulator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class exactPathDangerMotion
extends basicMotion {
    protected fighterBot myBot;
    private double superDanger = 1.0E8;
    dangerPath path = new dangerPath();
    long stopTime = (long)Math.ceil(4.0);
    long antiRammerPathTics = 32L;
    long minimalPathLength = Math.max(32L, 2L * this.stopTime);
    long maximalPathLength = 50L;
    long nTrials = 20L;
    long nTrialsToImprove = 2L;
    long wrongPathPredictionCount = 0L;

    @Override
    public void initTic() {
        if (this.path.size() >= 1) {
            long l = this.myBot.getTime();
            while (this.path.getFirst().getBotStatPoint().getTime() < l) {
                this.path.removeFirst();
                if (this.path.size() != 0) continue;
            }
        }
        if (this.path.size() >= 1 && !this.needToRecalculate) {
            if (this.myBot.getPosition().distance(this.path.getFirst().getPosition()) > 1.0) {
                ++this.wrongPathPredictionCount;
                this.needToRecalculate = true;
            }
            if (this.path.size() >= 1) {
                this.path.removeFirst();
            }
        } else {
            this.needToRecalculate = true;
        }
        if (this.needToRecalculate) {
            this.choseNewPath(Math.max(this.predictionEndTime - this.myBot.getTime(), this.maximalPathLength), this.nTrials);
            this.needToRecalculate = false;
        } else {
            this.choseNewPath(Math.max(this.predictionEndTime - this.myBot.getTime(), this.maximalPathLength), this.nTrialsToImprove);
        }
    }

    public exactPathDangerMotion() {
    }

    public exactPathDangerMotion(fighterBot fighterBot2) {
        this.myBot = fighterBot2;
        this.initBattle(this.myBot);
        this.destPoint = new dangerPoint(new Point2D.Double(0.0, 0.0), this.superDanger);
    }

    @Override
    public void manage() {
        if ((long)this.path.size() <= this.minimalPathLength) {
            this.needToRecalculate = true;
        }
        this.moveToPoint(this.destPoint.getPosition());
    }

    public void choseNewPath() {
        this.choseNewPath(this.maximalPathLength, this.nTrials);
    }

    public void choseNewPath(long l, long l2) {
        profiler.start("choseNewPath");
        l = (long)math.putWithinRange(l, this.minimalPathLength, this.maximalPathLength);
        Point2D.Double double_ = (Point2D.Double)this.myBot.getPosition().clone();
        Point2D.Double double_2 = (Point2D.Double)this.destPoint.getPosition().clone();
        this.path = new dangerPath(pathSimulator.getPathTo(double_2, this.myBot.getStatClosestToTime(this.myBot.getTime()), l));
        this.path.calculateDanger(this.myBot, this.superDanger);
        double d = 0.0;
        for (long i = 0L; i < l2; ++i) {
            double_2 = new Point2D.Double(0.0, 0.0);
            d = Math.PI * 2 * Math.random();
            double d2 = (double)l * 8.0 * Math.random();
            double_2.x = double_.x + d2 * Math.cos(d);
            double_2.y = double_.y + d2 * Math.sin(d);
            if (!physics.botReacheableBattleField.contains(double_2)) continue;
            dangerPath dangerPath2 = new dangerPath(pathSimulator.getPathTo(double_2, this.myBot.getStatClosestToTime(this.myBot.getTime()), l));
            dangerPath2.calculateDanger(this.myBot, this.path.getDanger());
            if (!(this.path.getDanger() > dangerPath2.getDanger())) continue;
            this.path = dangerPath2;
            this.destPoint = new dangerPoint(double_2, 0.0);
        }
        profiler.stop("choseNewPath");
    }

    @Override
    public void makeMove() {
    }

    @Override
    public void reportStats() {
        logger.routine("wrong path prediction count: " + this.wrongPathPredictionCount + " <------------------------------ improve me!");
    }

    public void drawFullDangerMap(Graphics2D graphics2D) {
        dangerMap dangerMap2 = new dangerMap(this.myBot);
        int n = 20;
        int n2 = 20;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                double_.x = physics.BattleField.x / (double)(n + 1) * (double)(i + 1);
                double_.y = physics.BattleField.y / (double)(n2 + 1) * (double)(j + 1);
                dangerMap2.add(double_);
            }
        }
        dangerMap2.calculateDanger(this.myBot.getTime());
        dangerMap2.onPaint(graphics2D);
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(0, 255, 0, 128));
        graphics.drawCircle(graphics2D, this.destPoint.getPosition(), 10.0);
        this.path.onPaint(graphics2D);
    }
}

