/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.ram;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.Scenario;
import xander.core.event.RoundBeginListener;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.WaveHistory;

public class RamLowEnergyScenario
implements Scenario,
RoundBeginListener {
    private RobotProxy robotProxy = Resources.getRobotProxy();
    private SnapshotHistory snapshotHistory = Resources.getSnapshotHistory();
    private WaveHistory waveHistory = Resources.getWaveHistory();
    private double opponentEnergy;
    private int ticksSinceNoWaves;
    private int noWavesTickCounter;
    private double fallbackOpponentEnergy;

    public RamLowEnergyScenario(double opponentEnergy, int ticksSinceNoWaves) {
        this.opponentEnergy = opponentEnergy;
        this.fallbackOpponentEnergy = opponentEnergy;
        this.ticksSinceNoWaves = ticksSinceNoWaves;
        Resources.getRobotEvents().addRoundBeginListener(this);
    }

    public void setFallbackOpponentEnergy(double fallbackOpponentEnergy) {
        this.fallbackOpponentEnergy = fallbackOpponentEnergy;
    }

    @Override
    public boolean applies() {
        Snapshot snapshot = this.snapshotHistory.getLastOpponentScanned();
        if (snapshot != null && snapshot.getEnergy() <= this.opponentEnergy && this.robotProxy.getEnergy() > 5.0) {
            if (this.ticksSinceNoWaves > 0) {
                if (this.waveHistory.getOpponentWaveCount() == 0) {
                    if (this.noWavesTickCounter > this.ticksSinceNoWaves) {
                        return true;
                    }
                    ++this.noWavesTickCounter;
                } else {
                    if (this.noWavesTickCounter > this.ticksSinceNoWaves) {
                        this.opponentEnergy = this.fallbackOpponentEnergy;
                    }
                    this.noWavesTickCounter = 0;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onRoundBegin() {
        this.noWavesTickCounter = 0;
    }
}

