/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import xander.core.AbstractXanderRobot;
import xander.core.math.RCMath;

public class DriveController {
    private AbstractXanderRobot robot;

    public void setRobot(AbstractXanderRobot robot) {
        this.robot = robot;
    }

    public void setMaxVelocity(double velocity) {
        this.robot.setMaxVelocity(velocity);
    }

    public void setTurnLeftDegrees(double degrees) {
        this.robot.setTurnLeft(degrees);
    }

    public void setTurnLeftRadians(double radians) {
        this.robot.setTurnLeftRadians(radians);
    }

    public void setTurnRightDegrees(double degrees) {
        this.robot.setTurnRight(degrees);
    }

    public void setTurnRightRadians(double radians) {
        this.robot.setTurnRightRadians(radians);
    }

    public void setAhead(double distance) {
        this.robot.setAhead(distance);
    }

    public void setBack(double distance) {
        this.robot.setBack(distance);
    }

    public double getDistanceRemaining() {
        return this.robot.getDistanceRemaining();
    }

    public void drive(double roboDegrees, double speed) {
        double heading = this.robot.getHeading();
        double velocity = speed;
        double turnAngle = RCMath.getTurnAngle(heading, roboDegrees);
        if (Math.abs(turnAngle) > 90.0) {
            heading = RCMath.normalizeDegrees(heading + 180.0);
            velocity = -speed;
            turnAngle = RCMath.getTurnAngle(heading, roboDegrees);
        }
        this.setTurnRightDegrees(turnAngle);
        this.setMaxVelocity(speed);
        if (speed == 0.0) {
            this.setAhead(0.0);
        } else if (velocity < 0.0) {
            this.setBack(300.0);
        } else {
            this.setAhead(300.0);
        }
    }
}

