/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import java.util.HashMap;
import java.util.Map;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.event.RoundBeginListener;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;
import xander.gfws.data.DataPoint;
import xander.gfws.data.LogReader;
import xander.gfws.data.WaveSearchIterable;

public abstract class CachingLogReader
implements LogReader,
RoundBeginListener,
MyWaveListener,
OpponentWaveListener {
    private Map<Wave, WaveSearchIterable<DataPoint>> logReaderHitCache = new HashMap<Wave, WaveSearchIterable<DataPoint>>();
    private Map<Wave, WaveSearchIterable<DataPoint>> logReaderVisitCache = new HashMap<Wave, WaveSearchIterable<DataPoint>>();

    public CachingLogReader() {
        Resources.getRobotEvents().addRoundBeginListener(this);
        Resources.getWaveHistory().addMyWaveListener(this);
        Resources.getWaveHistory().addOpponentWaveListener(this);
    }

    protected abstract WaveSearchIterable<DataPoint> readHitData(Wave var1);

    protected abstract WaveSearchIterable<DataPoint> readVisitData(Wave var1);

    @Override
    public WaveSearchIterable<DataPoint> getHitData(Wave wave) {
        WaveSearchIterable<DataPoint> data = this.logReaderHitCache.get(wave);
        if (data == null) {
            data = this.readHitData(wave);
            this.logReaderHitCache.put(wave, data);
        }
        return data;
    }

    @Override
    public WaveSearchIterable<DataPoint> getVisitData(Wave wave) {
        WaveSearchIterable<DataPoint> data = this.logReaderVisitCache.get(wave);
        if (data == null) {
            data = this.readVisitData(wave);
            this.logReaderVisitCache.put(wave, data);
        }
        return data;
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
    }

    @Override
    public void oppWaveHit(Wave wave) {
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
        this.logReaderHitCache.remove(wave);
        this.logReaderVisitCache.remove(wave);
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
        this.logReaderHitCache.remove(wave);
        this.logReaderVisitCache.remove(wave);
    }

    @Override
    public void onRoundBegin() {
        this.logReaderHitCache.clear();
        this.logReaderVisitCache.clear();
    }
}

