/*
 * Decompiled with CFR 0.152.
 */
package pedersen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import pedersen.core.Foundation;
import pedersen.misc.Host;
import pedersen.opponent.TargetBank;
import pedersen.systems.FireControl;
import pedersen.systems.FireControlBase;
import pedersen.systems.FireControlInterceptImpl;
import pedersen.systems.FireControlKaplooieImpl;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.movement.MovementMethodSetBuilder;
import pedersen.tactics.movement.MovementMethodSetImpl;
import pedersen.tactics.movement.impl.MovementMethodMoronImpl;
import pedersen.tactics.targeting.TargetingMethodBase;
import pedersen.tactics.targeting.impl.TargetingMethodDeadOnImpl;
import pedersen.tactics.targeting.impl.TargetingMethodMoronImpl;
import robocode.BulletHitEvent;
import robocode.RobotDeathEvent;

public class Moron
extends Foundation {
    static final int meleeLimit = 1;
    private static MovementMethodSetBuilder[] movementMethods = new MovementMethodSetBuilder[1];
    private static final Color chassis = new Color(255, 255, 255);
    private static final Color turret = new Color(0, 0, 0);
    private static final Color radar = new Color(255, 255, 255);
    static int hitCount = 0;
    static final int hitCountThreshold = 3;
    static boolean meleeMode = false;

    public Moron() {
        super(chassis, turret, radar);
    }

    public void run() {
        this.init();
        super.run();
    }

    protected void init() {
        Moron.movementMethods[0] = new MovementMethodSetImpl();
        movementMethods[0].addDynamicMovementMethod(new MovementMethodMoronImpl());
    }

    public MovementMethodSet getMovementMethods(int opponentCount) {
        return movementMethods[0];
    }

    public MovementMethodSetBuilder getMovementMethods() {
        MovementMethodSetImpl newMovementMethods = new MovementMethodSetImpl();
        newMovementMethods.addDynamicMovementMethod(new MovementMethodMoronImpl());
        return newMovementMethods;
    }

    public List getOffensiveTargetingMethods() {
        ArrayList targetingMethods = new ArrayList();
        return targetingMethods;
    }

    public List getDefensiveTargetingMethods() {
        ArrayList<TargetingMethodBase> targetingMethods = new ArrayList<TargetingMethodBase>();
        if (meleeMode || Host.singleton.getActiveEnemyCount() > 1) {
            meleeMode = true;
        } else if (hitCount < 3) {
            targetingMethods.add(new TargetingMethodDeadOnImpl());
        } else {
            targetingMethods.add(new TargetingMethodMoronImpl());
        }
        return targetingMethods;
    }

    public FireControl getFireControl() {
        FireControlBase fireControl = hitCount < 3 ? new FireControlInterceptImpl() : new FireControlKaplooieImpl();
        return fireControl;
    }

    public void onBulletHit(BulletHitEvent event) {
        ++hitCount;
        TargetBank.singleton.purge();
        super.onBulletHit(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        TargetBank.singleton.purge();
        super.onRobotDeath(event);
    }
}

