/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.debug.Debug;
import pedersen.physics.DynamicPosition;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;

public class DynamicPositionImpl
implements DynamicPosition {
    protected StaticPosition position;

    public DynamicPositionImpl() {
        this.position = new StaticPositionImpl(0.0, 0.0);
    }

    public DynamicPositionImpl(double newX, double newY) {
        this.position = new StaticPositionImpl(newX, newY);
    }

    public DynamicPositionImpl(StaticPosition newPosition) {
        this.position = new StaticPositionImpl(newPosition);
    }

    public StaticPosition getStaticPosition() {
        return this.position;
    }

    public void add(StaticPosition offset) {
        if (offset != null) {
            this.position = new StaticPositionImpl(this.position, offset);
        }
    }

    public void add(StaticVector vector) {
        this.position = new StaticPositionImpl(this.position, vector);
    }

    public StaticVector getVector() {
        double bearing = StaticPositionImpl.getBearing(this.position.getX(), this.position.getY());
        double magnitude = StaticPositionImpl.getAbsDistance(this.position.getX(), this.position.getY());
        return new StaticVectorImpl(bearing, magnitude);
    }

    public void debug() {
        Debug.debug("Dynamic position: ( " + Debug.trim(this.position.getX()) + ", " + Debug.trim(this.position.getY()) + " )");
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.position.equalsPosition(other);
    }

    public double getDistance(StaticPosition other) {
        return this.position.getDistance(other);
    }

    public double getBearing(StaticPosition other) {
        return this.position.getBearing(other);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.position.getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other) {
        return this.position.getRelativeVector(other);
    }
}

