/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.divination.WaveData;
import pedersen.misc.Arena;
import pedersen.physics.Projection;
import pedersen.physics.SlopeFormula;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.bot.SimpleGFSetup;
import pedersen.tactics.grail.WallProximity;

public class WaveAnalysis {
    private SimpleGFSetup gun = new SimpleGFSetup().initializeAsMostVisited();

    public void recordWave(WaveData waveData) {
        if (waveData.isLiveRound()) {
            this.gun.addWaveData(waveData);
        }
    }

    public double getBearingOffset(WaveData waveData, boolean isVirtual) {
        return this.gun.getBearingOffset(waveData);
    }

    public WaveData getWaveData(StaticPosition firingPosition, Snapshot target, double bulletVelocity) {
        double bearingToTarget = firingPosition.getBearing(target);
        StaticPosition projectedTarget = new Projection(target).project().getStaticPosition();
        double tangentalVelocity = WaveAnalysis.getTangentalVelocity(firingPosition, target);
        double headonVelocity = firingPosition.getDistance(target) - firingPosition.getDistance(projectedTarget);
        WallProximity wallProximity = WaveAnalysis.getWallProximity(target);
        return new WaveData(tangentalVelocity, headonVelocity, wallProximity.forward, wallProximity.reverse, bearingToTarget);
    }

    private static double getTangentalVelocity(StaticPosition firingPosition, Snapshot target) {
        double bearingToTarget = firingPosition.getBearing(target);
        StaticPosition projectedTarget = new Projection(target).project().getStaticPosition();
        StaticPositionImpl controlPosition = new StaticPositionImpl((StaticPosition)target, new StaticVectorImpl(bearingToTarget + 1.5707963267948966, 8.0));
        double bearingToProjectedTarget = Constraints.getNegativePiToPi(firingPosition.getBearing(projectedTarget) - bearingToTarget);
        double bearingToControlPosition = Constraints.getNegativePiToPi(firingPosition.getBearing(controlPosition) - bearingToTarget);
        double tangentalVelocity = bearingToProjectedTarget / bearingToControlPosition;
        return tangentalVelocity;
    }

    private static WallProximity getWallProximity(Snapshot target) {
        double distanceReverse;
        double distanceForward;
        SlopeFormula slopeFormula = new SlopeFormula(target, target);
        double heading = target.getHeading();
        if (target.getVelocity() < 0.0) {
            heading = Constraints.getZeroToTwoPi(heading + Math.PI);
        }
        double distanceToNorthWall = target.getDistance(slopeFormula.getPositionForY(Arena.getMaxY()));
        double distanceToEastWall = target.getDistance(slopeFormula.getPositionForX(Arena.getMaxX()));
        double distanceToSouthWall = target.getDistance(slopeFormula.getPositionForY(Arena.getMinY()));
        double distanceToWestWall = target.getDistance(slopeFormula.getPositionForX(Arena.getMinX()));
        if (heading < 1.5707963267948966) {
            distanceForward = distanceToNorthWall < distanceToEastWall ? distanceToNorthWall : distanceToEastWall;
            distanceReverse = distanceToSouthWall < distanceToWestWall ? distanceToSouthWall : distanceToWestWall;
        } else if (heading < Math.PI) {
            distanceForward = distanceToEastWall < distanceToSouthWall ? distanceToEastWall : distanceToSouthWall;
            distanceReverse = distanceToWestWall < distanceToNorthWall ? distanceToWestWall : distanceToNorthWall;
        } else if (heading < 4.71238898038469) {
            distanceForward = distanceToSouthWall < distanceToWestWall ? distanceToSouthWall : distanceToWestWall;
            distanceReverse = distanceToNorthWall < distanceToEastWall ? distanceToNorthWall : distanceToEastWall;
        } else {
            distanceForward = distanceToWestWall < distanceToNorthWall ? distanceToWestWall : distanceToNorthWall;
            distanceReverse = distanceToEastWall < distanceToSouthWall ? distanceToEastWall : distanceToSouthWall;
        }
        return new WallProximity(distanceForward, distanceReverse);
    }

    public void onFire() {
        this.gun.onFire();
    }

    public void debug() {
    }
}

