/*
 * Decompiled with CFR 0.152.
 */
package jaybot.adv.bots;

import jaybot.adv.bots.BotHelper;
import jaybot.adv.intel.Bot;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public abstract class BaseAdvBot
extends AdvancedRobot {
    public BaseAdvBot() {
        BotHelper.setupRobot(this);
        BotHelper.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.doOneTimeSetup();
        BotHelper.alert("Battle Beginning.");
        try {
            try {
                while (true) {
                    this.doRunStep();
                }
            }
            catch (Throwable t) {
                BotHelper.alert("!!!!!!!!!!!!!!!!!!!!!!! " + t.getMessage());
                this.doOneTimeEnding();
                BotHelper.alert("Battle Concluded.");
            }
        }
        catch (Throwable throwable) {
            this.doOneTimeEnding();
            BotHelper.alert("Battle Concluded.");
            throw throwable;
        }
    }

    protected abstract void doRunStep();

    protected abstract void doOneTimeSetup();

    protected abstract void doOneTimeEnding();

    protected abstract void doScanRobot(ScannedRobotEvent var1, Bot var2);

    protected abstract void doRobotDied(RobotDeathEvent var1, Bot var2);

    protected abstract void doCustomEvent(CustomEvent var1);

    protected abstract void doDeath(DeathEvent var1);

    protected abstract void doBulletHit(BulletHitEvent var1, Bot var2);

    protected abstract void doBulletHitBullet(BulletHitBulletEvent var1, Bot var2);

    protected abstract void doBulletMissed(BulletMissedEvent var1);

    protected abstract void doHitByBullet(HitByBulletEvent var1, Bot var2);

    protected abstract void doCollision(HitRobotEvent var1, Bot var2, boolean var3);

    protected abstract void doHitWall(HitWallEvent var1);

    protected abstract void doWin(WinEvent var1);

    protected void doSkipTurn(SkippedTurnEvent e) {
        BotHelper.alert("Lost Turn: " + e.toString());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Bot b = BotHelper.getEnemy(e.getName());
        b.updateFromEvent(e);
        this.doScanRobot(e, b);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Bot b = BotHelper.getEnemy(e.getName());
        b.updateFromEvent(e);
        BotHelper.killEnemy(b);
        this.doRobotDied(e, b);
    }

    public void onCustomEvent(CustomEvent e) {
        this.doCustomEvent(e);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.doSkipTurn(e);
    }

    public void onDeath(DeathEvent event) {
        this.doDeath(event);
    }

    public void onBulletHit(BulletHitEvent e) {
        Bot b = BotHelper.getEnemy(e.getName());
        b.updateFromEvent(e);
        this.doBulletHit(e, b);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        Bot b = BotHelper.getEnemy(event.getHitBullet().getName());
        this.doBulletHitBullet(event, b);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.doBulletMissed(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        Bot b = BotHelper.getEnemy(event.getName());
        this.doHitByBullet(event, b);
    }

    public void onHitRobot(HitRobotEvent event) {
        Bot b = BotHelper.getEnemy(event.getName());
        b.updateFromEvent(event);
        this.doCollision(event, b, event.isMyFault());
    }

    public void onHitWall(HitWallEvent event) {
        this.doHitWall(event);
    }

    public void onWin(WinEvent event) {
        this.doWin(event);
    }
}

