/*
 * Decompiled with CFR 0.152.
 */
package ustimaw;

import java.awt.Color;
import java.util.HashMap;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import ustimaw.Gun;
import ustimaw.Nightmare;
import ustimaw.Position;

class CircularTargeting
extends Gun {
    private final HashMap<String, Double> lastHeadings = new HashMap();
    private final HashMap<String, Double> headingDeltas = new HashMap();

    CircularTargeting() {
    }

    @Override
    double getAngle(Nightmare n, double p) {
        String t = n.target;
        if (t == null || !this.lastHeadings.containsKey(t)) {
            return 0.0;
        }
        ScannedRobotEvent sre = n.enemys.get((Object)t).sre;
        double v = sre.getVelocity();
        double h = sre.getHeadingRadians();
        Position ps = n.enemys.get(t).getPoint();
        long tm = sre.getTime();
        while (!(ps.distance(n.getPosition()) < (double)(tm - n.getTime()) * Rules.getBulletSpeed((double)p))) {
            ps = n.insidePoint(ps.add(Position.polar(v, h += this.headingDeltas.get(t).doubleValue())));
            n.printCircle(ps, 3, Color.pink);
            ++tm;
        }
        return ps.sub(n.getPosition()).arg();
    }

    @Override
    void update(Nightmare n) {
        for (String s : n.enemys.keySet()) {
            double nh = 0.0;
            double eh = n.enemys.get((Object)s).sre.getHeadingRadians();
            if (this.lastHeadings.containsKey(s)) {
                double w = 0.001;
                nh = this.headingDeltas.get(s) * (1.0 - w) + Utils.normalRelativeAngle((double)(eh - this.lastHeadings.get(s))) * w;
            }
            this.headingDeltas.put(s, nh);
            this.lastHeadings.put(s, eh);
        }
    }

    @Override
    String name() {
        return null;
    }
}

