/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.BulletItem;
import emp.Consts;
import emp.Enemy;
import emp.My;
import emp.Strategy;
import emp.Yngwie;
import java.awt.Polygon;
import java.util.Random;

public class Predictor
implements Consts {
    Yngwie yngwie;
    private static Random rand = new Random();
    private Enemy pe;
    private double BulletPowerAtEnemy;
    private double MaxFirePower;
    private double AdvicePower;
    private boolean canKillEnemy;

    public Predictor(Yngwie y) {
        this.yngwie = y;
        this.BulletPowerAtEnemy = 0.0;
        this.MaxFirePower = 0.0;
        this.AdvicePower = 0.0;
        this.canKillEnemy = false;
        this.pe = null;
    }

    private void SortStrategies() {
        if (this.pe.Strategies.size() < 2) {
            return;
        }
        int j = 0;
        while (j + 1 < this.pe.Strategies.size()) {
            Strategy S1 = (Strategy)this.pe.Strategies.elementAt(j);
            Strategy S2 = (Strategy)this.pe.Strategies.elementAt(j + 1);
            if (S2.Faith() > S1.Faith()) {
                this.pe.Strategies.removeElementAt(j);
                this.pe.Strategies.insertElementAt(S1, j + 1);
                j = 0;
                continue;
            }
            ++j;
        }
    }

    private void BlessBullet() {
        if (this.pe.HitX < 35.0) {
            this.pe.HitX = 35.0;
        } else if (this.pe.HitX > Yngwie.BattleFieldWidth - 35.0) {
            this.pe.HitX = Yngwie.BattleFieldWidth - 35.0;
        }
        if (this.pe.HitY < 35.0) {
            this.pe.HitY = 35.0;
        } else if (this.pe.HitY > Yngwie.BattleFieldHeight - 35.0) {
            this.pe.HitY = Yngwie.BattleFieldHeight - 35.0;
        }
    }

    public void Predict(Enemy en) {
        if (en == null || en.Death || this.yngwie.getEnergy() <= 0.1) {
            return;
        }
        this.pe = en;
        if (en.Energy() <= 0.0) {
            en.HitStrategy = 300;
            en.HitX = en.X();
            en.HitY = en.Y();
            en.HitPower = 0.1;
            return;
        }
        this.MaxFirePower = 3.0;
        if (this.yngwie.getEnergy() <= 3.0) {
            this.MaxFirePower = 0.1;
        } else if (this.yngwie.getEnergy() <= 8.0) {
            this.MaxFirePower = 1.0;
        }
        if (this.pe.Energy() < 16.0) {
            this.canKillEnemy = true;
            double PowerToKill = My.getBulletPowerToKill(this.pe.Energy());
            this.MaxFirePower = this.yngwie.getBulletDamageAimedAt(en) > PowerToKill ? Math.min(this.MaxFirePower, 1.0) : Math.min(this.MaxFirePower, PowerToKill);
        } else {
            this.canKillEnemy = false;
        }
        double dist = this.yngwie.Distance(this.pe);
        if (Yngwie.OneOnOne && Yngwie.BattleFieldHeight == 600.0) {
            this.AdvicePower = dist < 200.0 ? 3.0 : (dist < 400.0 ? 2.0 : 1.5);
        } else if (Yngwie.OneOnOne && Yngwie.BattleFieldHeight != 600.0) {
            this.AdvicePower = dist < 200.0 ? 3.0 : (dist < 400.0 ? 2.0 : (dist < 800.0 ? 1.0 : 0.5));
        } else {
            this.AdvicePower = dist < 150.0 ? 3.0 : (dist < 400.0 ? 1.0 : 0.5);
            int i = 0;
            while (true) {
                if (i >= Yngwie.EC.Enemies.size()) break;
                Enemy e = (Enemy)Yngwie.EC.Enemies.elementAt(i);
                if (!e.Death && e.Time() != (long)-1 && e != en && e.Time() == this.yngwie.getTime() && My.absADiffDeg(this.yngwie.AngleTo(e), this.yngwie.AngleTo(en)) < 4.0) {
                    if (!(this.yngwie.Distance(e) < 400.0)) break;
                    this.AdvicePower = Math.min(3.0, this.AdvicePower + 0.5);
                    break;
                }
                ++i;
            }
        }
        en.HitPower = 0.0;
        en.HitX = en.X();
        en.HitY = en.Y();
        this.SortStrategies();
        for (int i = 0; i < en.Strategies.size(); ++i) {
            Strategy s = (Strategy)en.Strategies.elementAt(i);
            if (s.ID == 300) continue;
            if (s.ID == 301) {
                en.HitStrategy = 301;
                en.HitX = en.X();
                en.HitY = en.Y();
                en.HitPower = Math.min(this.MaxFirePower, Math.max(0.1, 2.0 * s.Faith() / 100.0));
                return;
            }
            if (s.ID == 302 ? this.HistoryPredictor(s.ID) : (s.ID == 307 ? this.CloseRangePredict() : (s.ID == 308 ? this.SquarePredict() : (s.ID == 303 ? this.HistoryPredictor(s.ID) : (s.ID == 306 ? this.SprayPredict(en) : (s.ID == 305 ? this.HistoryPredictor(s.ID) : (s.ID == 304 ? this.LinearPredict() : (s.ID == 309 || s.ID == 310) && this.DodgePredict(s.ID)))))))) break;
        }
        this.BlessBullet();
    }

    private boolean HistoryPredictor(int sID) {
        HistoryMatchInfo h = this.HistoryMatch(sID);
        if (h.Found) {
            return this.GuessHitPoint(h);
        }
        return false;
    }

    private boolean DodgePredict(int sID) {
        double score;
        BulletItem bi;
        int i;
        if (this.pe.BulletList.size() < 10) {
            return false;
        }
        double bestScore = 0.0;
        int bestItem = -1;
        double bearingNow = My.absADiffDeg2(this.yngwie.AngleTo(this.pe), this.pe.Heading());
        double dist = this.yngwie.Distance(this.pe);
        int lastIndex = 0;
        if (this.pe.BulletList.size() > 1000) {
            lastIndex = 0 * this.pe.BulletList.size();
        } else if (this.pe.BulletList.size() > 100) {
            lastIndex = 0 * this.pe.BulletList.size();
        }
        if (sID == 309) {
            for (i = this.pe.BulletList.size() - 1; i >= lastIndex; --i) {
                double score3;
                double score2;
                double score1;
                bi = (BulletItem)this.pe.BulletList.elementAt(i);
                if (bi.OneOnOne != Yngwie.OneOnOne || !((score = (score1 = 17.0 - Math.abs(this.pe.Velocity() - bi.EnemyVelocity)) * (score2 = 10.0 - My.absADiffDeg(bearingNow, bi.EnemyBearing) / 20.0) * (score3 = Math.max(1.0, 10.0 - Math.abs(dist - bi.Distance) / 30.0))) > bestScore)) continue;
                bestScore = score;
                bestItem = i;
            }
        } else {
            for (i = this.pe.BulletList.size() - 1; i >= lastIndex; --i) {
                bi = (BulletItem)this.pe.BulletList.elementAt(i);
                if (bi.OneOnOne != Yngwie.OneOnOne) continue;
                score = 10.0 - 0.25 * Math.abs(this.pe.Velocity() - bi.EnemyVelocity);
                score *= Math.max(0.1, 2.0 - Math.abs(this.AdvicePower - bi.firePower));
                if (!((score *= Math.max(1.0, 10.0 - Math.abs(dist - bi.Distance) / 20.0)) > bestScore)) continue;
                bestScore = score;
                bestItem = i;
            }
        }
        if (bestItem == -1) {
            return false;
        }
        bi = (BulletItem)this.pe.BulletList.elementAt(bestItem);
        if (sID == 309) {
            double hoek = My.AddDegrees(this.pe.Heading(), bi.DeviationAngle);
            double snelheid = bi.Deviation / bi.Duration;
            double MaxTurns = bi.Duration + (double)4;
            for (int k = 6; k >= 0; --k) {
                double Power;
                if (k == 6 && this.canKillEnemy) {
                    Power = this.MaxFirePower;
                } else {
                    Power = Math.max((double)k * 0.5, 0.1);
                    if (Power > this.MaxFirePower || Power > this.AdvicePower) continue;
                }
                double Speed = My.getBulletVelocity(Power);
                double damage = My.getBulletDamage(Power);
                double TargetX = this.pe.X();
                double TargetY = this.pe.Y();
                long Turns = 1L;
                while ((double)Turns < MaxTurns && this.PointInBattleField(TargetX, TargetY)) {
                    if (My.Distance(TargetX, TargetY, this.yngwie.X, this.yngwie.Y) - 18.0 < Speed * (double)Turns) {
                        this.pe.HitX = TargetX;
                        this.pe.HitY = TargetY;
                        this.pe.HitPower = Power;
                        this.pe.HitStrategy = 309;
                        return true;
                    }
                    TargetX += snelheid * My.sinDeg(hoek);
                    TargetY += snelheid * My.cosDeg(hoek);
                    ++Turns;
                }
            }
            return false;
        }
        if (sID == 310) {
            double TargetY;
            if (Math.abs(dist - bi.Distance) > 30.0) {
                return false;
            }
            double TargetX = this.pe.X() + bi.Deviation * My.sinDeg(My.AddDegrees(this.pe.Heading(), bi.DeviationAngle));
            if (this.PointInBattleField(TargetX, TargetY = this.pe.Y() + bi.Deviation * My.cosDeg(My.AddDegrees(this.pe.Heading(), bi.DeviationAngle))) && bi.firePower <= this.MaxFirePower) {
                this.pe.HitX = TargetX;
                this.pe.HitY = TargetY;
                this.pe.HitPower = bi.firePower;
                this.pe.HitStrategy = 310;
                return true;
            }
        }
        return false;
    }

    private boolean SquarePredict() {
        if (this.pe.RC < 60) {
            return false;
        }
        double CenterX = 0.0;
        double CenterY = 0.0;
        double MaxLeft = Yngwie.BattleFieldWidth;
        double MaxRight = 0.0;
        double MaxTop = 0.0;
        double MaxBottom = Yngwie.BattleFieldHeight;
        long curTime = this.yngwie.getTime();
        int count = 0;
        for (int k = this.pe.RC - 1; (double)curTime - this.pe.Records[k][0] < (double)50 && this.pe.Records[k][0] > (double)20 && k > 5; --k) {
            CenterX += this.pe.Records[k][1];
            CenterY += this.pe.Records[k][2];
            if (this.pe.Records[k][1] > MaxRight) {
                MaxRight = this.pe.Records[k][1];
            }
            if (this.pe.Records[k][1] < MaxLeft) {
                MaxLeft = this.pe.Records[k][1];
            }
            if (this.pe.Records[k][2] < MaxBottom) {
                MaxBottom = this.pe.Records[k][2];
            }
            if (!(this.pe.Records[k][2] > MaxTop)) continue;
            MaxTop = this.pe.Records[k][2];
            if (++count != 40) continue;
            double Precision = Math.max(1.0, (MaxRight - MaxLeft) / 36.0);
            double Power = Math.min(this.MaxFirePower, Math.max(0.0, 4.0 - 0.8 * Math.sqrt(Precision *= Math.max(1.0, (MaxTop - MaxBottom) / 36.0))));
            if (!(Power > 0.0)) continue;
            this.pe.HitX = CenterX / (double)count;
            this.pe.HitY = CenterY / (double)count;
            this.pe.HitPower = Power;
            this.pe.HitStrategy = 308;
            return true;
        }
        return false;
    }

    private boolean LinearPredict() {
        if (this.pe.RC < 7) {
            return false;
        }
        double snelheid = 0.0;
        double draaihoek = 0.0;
        int histories = 5;
        double LastCorr = 1.0;
        double TestCorr = 1.0;
        double dist = this.yngwie.Distance(this.pe);
        for (int k = this.pe.RC - histories - 1; TestCorr * LastCorr > 0.9 && this.pe.Records[k][0] == this.pe.Records[k - 1][0] + 1.0 && k < this.pe.RC; ++k) {
            TestCorr *= LastCorr;
            if (k == this.pe.RC - 1) {
                snelheid /= (double)histories;
                draaihoek /= (double)histories;
                for (int z = 6; z >= 0; --z) {
                    double Power;
                    if (z == 6 && this.canKillEnemy) {
                        Power = this.MaxFirePower;
                    } else {
                        Power = Math.max((double)z * 0.5, 0.1);
                        if (Power > this.MaxFirePower || Power > this.AdvicePower) continue;
                    }
                    double Speed = My.getBulletVelocity(Power);
                    double damage = My.getBulletDamage(Power);
                    double TargetX = this.pe.X();
                    double TargetY = this.pe.Y();
                    double TargetH = this.pe.Heading();
                    for (int Turns = 1; Turns < 25 && this.PointInBattleField(TargetX, TargetY); ++Turns) {
                        if (My.Distance(TargetX, TargetY, this.yngwie.X, this.yngwie.Y) - 18.0 < Speed * (double)Turns) {
                            this.pe.HitX = TargetX;
                            this.pe.HitY = TargetY;
                            this.pe.HitPower = Power;
                            this.pe.HitStrategy = 304;
                            return true;
                        }
                        TargetH = My.AddDegrees(TargetH, draaihoek);
                        TargetX += snelheid * My.sinDeg(TargetH);
                        TargetY += snelheid * My.cosDeg(TargetH);
                    }
                }
            }
            LastCorr = 1.0 - 0.02 * My.abs(this.pe.Records[k - 1][3] - this.pe.Records[k][3]);
            snelheid += this.pe.Records[k][3];
            if (LastCorr < 0.0) break;
            LastCorr *= 1.0 - 0.003 * My.abs(this.pe.Records[k - 1][5] - this.pe.Records[k][5]);
            draaihoek += this.pe.Records[k][5];
        }
        return false;
    }

    private void ComputeEnemyRange(Enemy en, Polygon range, boolean ahead, double Degrees, double bSpeed) {
        int Turns = 1;
        double TargetX = en.X();
        double TargetY = en.Y();
        double TargetH = en.Heading();
        double TargetSpeed = en.Velocity();
        double Turned = 0.0;
        double MaxTurning = 0.0;
        while (My.Distance(this.yngwie.X, this.yngwie.Y, TargetX, TargetY) - 18.0 > (double)Turns * bSpeed) {
            MaxTurning = My.getRobotMaxTurning(TargetSpeed);
            if (Degrees >= 0.0 && Turned < Degrees) {
                if (Degrees - Turned >= MaxTurning) {
                    TargetH += MaxTurning;
                    Turned += MaxTurning;
                } else {
                    TargetH += Degrees - Turned;
                    Turned += Degrees - Turned;
                }
            } else if (Degrees < 0.0 && Turned < -Degrees) {
                if (-Degrees - Turned >= MaxTurning) {
                    TargetH -= MaxTurning;
                    Turned += MaxTurning;
                } else {
                    TargetH = TargetH + Degrees + Turned;
                    Turned -= Degrees + Turned;
                }
            }
            if (TargetH >= 360.0) {
                TargetH -= 360.0;
            } else if (TargetH < 0.0) {
                TargetH += 360.0;
            }
            TargetSpeed = My.getRobotAccVelocity(TargetSpeed, ahead);
            TargetX += TargetSpeed * My.sinDeg(TargetH);
            TargetY += TargetSpeed * My.cosDeg(TargetH);
            if (TargetX < 18.0) {
                if (TargetY < 18.0) {
                    TargetY = 18.0;
                }
                TargetX = 18.0;
                break;
            }
            if (TargetY < 18.0) {
                TargetY = 18.0;
                break;
            }
            if (TargetX > Yngwie.BattleFieldWidth - 18.0) {
                if (TargetY > Yngwie.BattleFieldHeight - 18.0) {
                    TargetY = Yngwie.BattleFieldHeight - 18.0;
                }
                TargetX = Yngwie.BattleFieldWidth - 18.0;
                break;
            }
            if (TargetY > Yngwie.BattleFieldHeight - 18.0) {
                TargetY = Yngwie.BattleFieldHeight - 18.0;
                break;
            }
            ++Turns;
        }
        range.addPoint((int)TargetX, (int)TargetY);
    }

    private boolean CloseRangePredict() {
        if (!(this.yngwie.Distance(this.pe) < 150.0)) {
            return false;
        }
        double Power = 3.0;
        Power = Math.min(Power, this.MaxFirePower);
        double Speed = My.getBulletVelocity(Power);
        Polygon EnemyRange = new Polygon();
        if (this.pe.Velocity() >= 0.0) {
            this.ComputeEnemyRange(this.pe, EnemyRange, true, -90.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, -45.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, 0.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, 45.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, 90.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, -45.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, 0.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, 45.0, Speed);
        } else {
            this.ComputeEnemyRange(this.pe, EnemyRange, false, 90.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, -45.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, 0.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, true, 45.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, -90.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, -45.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, 0.0, Speed);
            this.ComputeEnemyRange(this.pe, EnemyRange, false, 45.0, Speed);
        }
        int[] x = EnemyRange.xpoints;
        int[] y = EnemyRange.ypoints;
        double avg_x = 0.0;
        double avg_y = 0.0;
        for (int i = 0; i < 8; ++i) {
            if (x[i] < 18) {
                x[i] = 18;
            } else if ((double)x[i] > Yngwie.BattleFieldWidth - (double)18) {
                x[i] = (int)Yngwie.BattleFieldWidth - 18;
            }
            if (y[i] < 18) {
                y[i] = 18;
            } else if ((double)y[i] > Yngwie.BattleFieldHeight - (double)18) {
                y[i] = (int)Yngwie.BattleFieldHeight - 18;
            }
            avg_x += (double)x[i];
            avg_y += (double)y[i];
        }
        this.pe.HitX = avg_x /= 8.0;
        this.pe.HitY = avg_y /= 8.0;
        this.pe.HitPower = Power;
        this.pe.HitStrategy = 307;
        return true;
    }

    private boolean SprayPredict(Enemy en) {
        double dist = this.yngwie.Distance(en);
        double Power = this.canKillEnemy ? this.MaxFirePower : Math.min(this.AdvicePower, this.MaxFirePower);
        double Speed = My.getBulletVelocity(Power);
        double damage = My.getBulletDamage(Power);
        double tijd = (dist - 18.0) / Speed + 1.0;
        double TargetX = en.X() + Math.sqrt(tijd) * en.Velocity() * My.sinDeg(en.Heading());
        double TargetY = en.Y() + Math.sqrt(tijd) * en.Velocity() * My.cosDeg(en.Heading());
        double targethoek = this.yngwie.NextTurnAngleTo(en);
        double sindraaihoek = My.abs(My.sinDeg((targethoek - en.Heading() + 360.0) % 360.0));
        double myr = rand.nextGaussian();
        en.HitX = TargetX + 0.5 * (sindraaihoek + 0.5) * tijd * myr * My.sinDeg((targethoek + (double)90) % (double)360);
        en.HitY = TargetY + 0.5 * (sindraaihoek + 0.5) * tijd * myr * My.cosDeg((targethoek + (double)90) % (double)360);
        en.HitPower = Power;
        en.HitStrategy = 306;
        return true;
    }

    private boolean PointInBattleField(double X, double Y) {
        return X >= 18.0 & Y >= 18.0 & X <= Yngwie.BattleFieldWidth - 18.0 & Y <= Yngwie.BattleFieldHeight - 18.0;
    }

    private boolean GuessHitPoint(HistoryMatchInfo h) {
        block0: for (int k = 6; k >= 0; --k) {
            int i;
            double Power;
            if (k == 6 && this.canKillEnemy) {
                Power = this.MaxFirePower;
            } else {
                Power = Math.max((double)k * 0.5, 0.1);
                if (Power > this.MaxFirePower || Power > this.AdvicePower) continue;
            }
            double Speed = My.getBulletVelocity(Power);
            double damage = My.getBulletDamage(Power);
            double TargetX = this.pe.X();
            double TargetY = this.pe.Y();
            double TargetH = this.pe.Heading();
            int Turns = 0;
            if (h.Type == 305) {
                while (Turns < 30 && this.PointInBattleField(TargetX, TargetY)) {
                    if (My.Distance(TargetX, TargetY, this.yngwie.X, this.yngwie.Y) - 18.0 < Speed * (double)Turns) {
                        this.pe.HitX = TargetX;
                        this.pe.HitY = TargetY;
                        this.pe.HitPower = Power;
                        this.pe.HitStrategy = h.Type;
                        return true;
                    }
                    if (i < this.pe.RC - 1 && this.pe.Records[i][0] - this.pe.Records[i - 1][0] == 1.0) {
                        TargetX += this.pe.Records[i][3] * My.sinDeg(TargetH);
                        TargetY += this.pe.Records[i][3] * My.cosDeg(TargetH);
                    } else {
                        if (i != this.pe.RC - 1) continue block0;
                        TargetX += this.pe.Velocity() * My.sinDeg(TargetH);
                        TargetY += this.pe.Velocity() * My.cosDeg(TargetH);
                    }
                    ++Turns;
                    ++i;
                }
                continue;
            }
            for (i = h.Idx + 1; Turns < 40 && i < this.pe.RC - 1 && this.pe.Records[i][0] - this.pe.Records[i - 1][0] == 1.0 && this.PointInBattleField(TargetX, TargetY); ++Turns, ++i) {
                if (My.Distance(TargetX, TargetY, this.yngwie.X, this.yngwie.Y) < Speed * (double)Turns) {
                    this.pe.HitX = TargetX;
                    this.pe.HitY = TargetY;
                    this.pe.HitPower = Power;
                    this.pe.HitStrategy = h.Type;
                    return true;
                }
                if (h.Type == 302) {
                    TargetX = this.pe.Records[i][1];
                    TargetY = this.pe.Records[i][2];
                    continue;
                }
                if (h.Type != 303) continue;
                TargetH = My.AddDegrees(TargetH, this.pe.Records[i][5]);
                TargetX += this.pe.Records[i][3] * My.sinDeg(TargetH);
                TargetY += this.pe.Records[i][3] * My.cosDeg(TargetH);
            }
        }
        return false;
    }

    private HistoryMatchInfo HistoryMatch(int pred) {
        int BestIdx = 0;
        int BestLength = 0;
        double BestCorr = 0.0;
        for (int TestIdx = this.pe.RC - 10; TestIdx > 10; --TestIdx) {
            double LastCorr = 1.0;
            double TestCorr = 1.0;
            int TestLength = -1;
            int j = TestIdx;
            int k = this.pe.RC - 1;
            while (j > 1 && TestCorr * LastCorr > 0.9 && this.pe.Records[j][0] == this.pe.Records[j - 1][0] + 1.0 && this.pe.Records[k][0] == this.pe.Records[k - 1][0] + 1.0 && TestLength < this.pe.RC - TestIdx && TestLength <= 30) {
                TestCorr *= LastCorr;
                if (pred == 302) {
                    LastCorr = 1.0 - 0.03 * My.abs(this.pe.Records[j][1] - this.pe.Records[k][1]);
                    if (LastCorr < 0.0) break;
                    LastCorr *= 1.0 - 0.03 * My.abs(this.pe.Records[j][2] - this.pe.Records[k][2]);
                } else if (pred == 303) {
                    LastCorr = 1.0 - 0.03 * My.abs(this.pe.Records[j][3] - this.pe.Records[k][3]);
                    if (LastCorr < 0.0) break;
                    LastCorr *= 1.0 - 0.01 * My.abs(this.pe.Records[j][5] - this.pe.Records[k][5]);
                } else if (pred == 305) {
                    LastCorr = 1.0 - 0.02 * My.abs(this.pe.Records[j][3] - this.pe.Records[k][3]);
                }
                ++TestLength;
                --j;
                --k;
            }
            if (TestLength <= 5 || !(TestCorr > 0.9) || !(TestCorr > BestCorr && TestLength >= BestLength) && (!(TestCorr > BestCorr - 1.0) || TestLength <= BestLength)) continue;
            BestCorr = TestCorr;
            BestLength = TestLength;
            BestIdx = TestIdx;
            if (BestLength >= 30) break;
        }
        HistoryMatchInfo result = new HistoryMatchInfo(this);
        result.Found = BestLength > 0;
        result.Idx = BestIdx;
        result.Length = BestLength;
        result.Corr = BestCorr;
        result.Type = pred;
        return result;
    }

    private class HistoryMatchInfo
    implements Consts {
        public int Idx = 0;
        public int Length = 0;
        public double Corr = 0.0;
        public boolean Found = false;
        public int Type;

        public HistoryMatchInfo(Predictor this$0) {
        }
    }
}

