/*
 * Decompiled with CFR 0.152.
 */
package inonit.script.engine;

import inonit.script.engine.Code;
import inonit.script.runtime.io.Streams;
import inonit.system.Logging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class Java {
    private static final Logging LOG = Logging.get();
    private static JavaCompiler javac;

    private static JavaCompiler compiler() {
        if (javac == null) {
            javac = ToolProvider.getSystemJavaCompiler();
        }
        return javac;
    }

    static Code.Loader compiling(Code.Loader base, Store store, ClassLoader dependencies) {
        return new SourceDirectoryClassesSource(base, store, dependencies);
    }

    static abstract class Store {
        Store() {
        }

        final String getClassLocationString(String name) {
            return name.replaceAll("\\.", "/") + ".class";
        }

        abstract OutputStream createOutputStreamAt(String var1);

        final OutputStream createOutputStream(String className) {
            return this.createOutputStreamAt(this.getClassLocationString(className));
        }

        abstract Code.Loader.Resource readAt(String var1);

        Code.Loader.Resource read(String className) {
            return this.readAt(this.getClassLocationString(className));
        }

        abstract void removeAt(String var1);

        final void remove(String name) {
            this.removeAt(this.getClassLocationString(name));
        }

        static Store memory() {
            return new Store(){
                private HashMap<String, InMemoryWritableFile> map = new HashMap();

                private InMemoryWritableFile create(String name) {
                    if (this.map.get(name) == null) {
                        this.map.put(name, new InMemoryWritableFile());
                    }
                    return this.map.get(name);
                }

                @Override
                OutputStream createOutputStreamAt(String location) {
                    return this.create(location).createOutputStream();
                }

                @Override
                Code.Loader.Resource readAt(String location) {
                    return this.map.get(location);
                }

                @Override
                void removeAt(String name) {
                    this.map.remove(name);
                }
            };
        }

        static Store file(final File file) {
            return new Store(){

                public String toString() {
                    return "Java.Store: directory = " + file;
                }

                @Override
                OutputStream createOutputStreamAt(String location) {
                    File destination = new File(file, location);
                    destination.getParentFile().mkdirs();
                    try {
                        LOG.log(Java.class, Level.FINE, "Writing class to " + destination, null);
                        return new FileOutputStream(destination);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                Code.Loader.Resource readAt(String location) {
                    final File source = new File(file, location);
                    if (!source.exists()) {
                        return null;
                    }
                    if (!source.exists()) {
                        return null;
                    }
                    return new Code.Loader.Resource(){

                        @Override
                        public Code.Loader.URI getURI() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public String getSourceName() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public InputStream getInputStream() {
                            try {
                                return new FileInputStream(source);
                            }
                            catch (FileNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        public Long getLength() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public Date getLastModified() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }

                @Override
                void removeAt(String location) {
                    File at = new File(file, location);
                    if (at.exists()) {
                        at.delete();
                    }
                    if (at.exists()) {
                        at.delete();
                    }
                }
            };
        }

        private static class InMemoryWritableFile
        extends Code.Loader.Resource {
            private MyOutputStream out;
            private Date modified;

            private InMemoryWritableFile() {
            }

            OutputStream createOutputStream() {
                this.modified = null;
                this.out = new MyOutputStream();
                return this.out;
            }

            @Override
            public Code.Loader.URI getURI() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public String getSourceName() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public InputStream getInputStream() {
                if (this.modified == null) {
                    throw new IllegalStateException("Stream is currently being written.");
                }
                return new ByteArrayInputStream(this.out.delegate().toByteArray());
            }

            @Override
            public Long getLength() {
                if (this.modified == null) {
                    throw new IllegalStateException("Stream is currently being written.");
                }
                return new Long(this.out.delegate().toByteArray().length);
            }

            @Override
            public Date getLastModified() {
                if (this.modified == null) {
                    throw new IllegalStateException("Stream is currently being written.");
                }
                return this.modified;
            }

            private class MyOutputStream
            extends OutputStream {
                private ByteArrayOutputStream delegate = new ByteArrayOutputStream();

                private MyOutputStream() {
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    InMemoryWritableFile.this.modified = new Date();
                }

                @Override
                public void flush() throws IOException {
                    this.delegate.flush();
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.delegate.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    this.delegate.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.delegate.write(b);
                }

                ByteArrayOutputStream delegate() {
                    return this.delegate;
                }
            }
        }
    }

    private static class SourceDirectoryClassesSource
    extends Code.Loader {
        private Code.Loader delegate;
        private Classes classes;
        private HashMap<String, Code.Loader.Resource> cache = new HashMap();

        SourceDirectoryClassesSource(Code.Loader delegate, Store store, ClassLoader classLoader) {
            this.delegate = delegate;
            this.classes = Classes.create(store, classLoader);
        }

        public String toString() {
            return "SourceDirectoryClassesSource: src=" + this.delegate;
        }

        private boolean hasClass(String name) {
            try {
                Class<?> c = Java.class.getClassLoader().loadClass(name);
                return c != null;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        @Override
        public Code.Loader.Resource getFile(String path) throws IOException {
            if (path.startsWith("org/apache/")) {
                return null;
            }
            if (path.startsWith("javax/")) {
                return null;
            }
            if (this.cache.get(path) == null) {
                Code.Loader.Resource stored = this.classes.store().readAt(path);
                if (stored != null) {
                    this.cache.put(path, stored);
                } else {
                    String className = path.substring(0, path.length() - ".class".length());
                    String sourceName = className + ".java";
                    if (sourceName.indexOf("$") == -1) {
                        boolean success;
                        Code.Loader.Resource sourceFile = this.delegate.getFile("java/" + sourceName);
                        if (sourceFile == null && this.hasClass("org.mozilla.javascript.Context")) {
                            sourceFile = this.delegate.getFile("rhino/java/" + sourceName);
                        }
                        if (sourceFile != null && !(success = this.classes.compile(sourceFile))) {
                            throw new RuntimeException("Failure: sourceFile=" + sourceFile);
                        }
                    }
                    this.cache.put(path, this.classes.getFile(className.replace("/", ".")));
                }
            }
            return this.cache.get(path);
        }

        @Override
        public Code.Loader.Enumerator getEnumerator() {
            return null;
        }

        @Override
        public Code.Locator getLocator() {
            return null;
        }
    }

    private static class Classes {
        private MyJavaFileManager jfm;

        private static Classes create(Store store, ClassLoader dependencies) {
            return new Classes(store, dependencies);
        }

        private Classes(Store store, ClassLoader dependencies) {
            this.jfm = new MyJavaFileManager(store, dependencies);
        }

        private Code.Loader.Resource getFile(String name) {
            MyJavaFileManager.OutputClass jfo = this.jfm.getJavaFileForInput(null, name, null);
            if (jfo == null) {
                return null;
            }
            return jfo.toCodeSourceFile();
        }

        private boolean compile(JavaFileObject jfo) {
            JavaCompiler.CompilationTask task = Java.compiler().getTask(null, this.jfm, null, Arrays.asList("-Xlint:unchecked"), null, Arrays.asList(jfo));
            boolean success = task.call();
            return success;
        }

        private boolean compile(Code.Loader.Resource javaSource) {
            return this.compile(new SourceFileObject(javaSource));
        }

        final Store store() {
            return this.jfm.store();
        }

        private static class MyJavaFileManager
        implements JavaFileManager {
            private JavaFileManager delegate = Java.access$000().getStandardFileManager(null, null, null);
            private Store store;
            private final ClassLoader classLoader;
            private Map<String, OutputClass> map = new HashMap<String, OutputClass>();
            private Code.Loader parent;

            MyJavaFileManager(Store store, ClassLoader classLoader) {
                this.store = store;
                this.classLoader = classLoader;
            }

            private void log(String message) {
                LOG.log(MyJavaFileManager.class, Level.FINE, message, null);
            }

            private void log(Level level, String message) {
                LOG.log(MyJavaFileManager.class, level, message, null);
            }

            private Code.Loader parent() {
                ClassLoader parentClassLoader;
                if (this.parent == null && (parentClassLoader = this.classLoader.getParent()) instanceof URLClassLoader) {
                    this.parent = Code.Loader.create((URLClassLoader)parentClassLoader);
                }
                return this.parent;
            }

            final Store store() {
                return this.store;
            }

            @Override
            public ClassLoader getClassLoader(JavaFileManager.Location location) {
                this.log("getClassLoader");
                if (location == StandardLocation.CLASS_PATH) {
                    return this.classLoader;
                }
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                if (location == StandardLocation.PLATFORM_CLASS_PATH) {
                    LOG.log(MyJavaFileManager.class, Level.FINER, "list location=" + location + " packageName=" + packageName + " kinds=" + kinds + " recurse=" + recurse, null);
                    Iterable<JavaFileObject> rv = this.delegate.list(location, packageName, kinds, recurse);
                    for (JavaFileObject o : rv) {
                        this.log(Level.FINER, "list jfo " + o);
                    }
                    return rv;
                }
                if (location == StandardLocation.CLASS_PATH) {
                    ArrayList<JavaFileObject> rv = new ArrayList<JavaFileObject>();
                    LOG.log(MyJavaFileManager.class, Level.FINE, "list location=" + location + " packageName=" + packageName + " kinds=" + kinds + " recurse=" + recurse, null);
                    Code.Loader parent = this.parent();
                    if (parent != null) {
                        LOG.log(MyJavaFileManager.class, Level.FINE, "parent=" + parent, null);
                        String path = packageName.replaceAll("\\.", "/");
                        LOG.log(MyJavaFileManager.class, Level.FINE, "path=" + path, null);
                        LOG.log(MyJavaFileManager.class, Level.FINE, "parent=" + parent, null);
                        if (parent.getEnumerator() == null) {
                            throw new Error("Parent enumerator is null for " + parent);
                        }
                        List<String> names = Arrays.asList(parent.getEnumerator().list(path));
                        for (String name : names) {
                            if (name.endsWith("/")) continue;
                            Code.Loader.Resource file = parent.getFile(path + "/" + name);
                            if (name.length() < ".class".length()) {
                                throw new RuntimeException("name is " + name);
                            }
                            String binaryName = path + "/" + name.substring(0, name.length() - ".class".length());
                            binaryName = binaryName.replaceAll("\\/", ".");
                            rv.add(new InputClass(file, binaryName));
                        }
                        LOG.log(MyJavaFileManager.class, Level.FINE, "path=" + path + " list=" + names, null);
                    } else {
                        LOG.log(MyJavaFileManager.class, Level.FINE, "classpath is null", null);
                    }
                    Iterable<JavaFileObject> standard = this.delegate.list(location, packageName, kinds, recurse);
                    for (JavaFileObject s : standard) {
                        rv.add(s);
                    }
                    return rv;
                }
                if (location == StandardLocation.SOURCE_PATH) {
                    return Arrays.asList(new JavaFileObject[0]);
                }
                throw new RuntimeException("No list() implementation for " + location);
            }

            @Override
            public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                if (location == StandardLocation.PLATFORM_CLASS_PATH) {
                    String rv = this.delegate.inferBinaryName(location, file);
                    this.log(Level.FINER, "inferBinaryName location=" + location + " file=" + file + " rv=" + rv);
                    return rv;
                }
                if (file instanceof InputClass) {
                    String rv = ((InputClass)file).binaryName();
                    this.log("inferBinaryName location=" + location + " file object " + file + " rv=" + rv);
                    return rv;
                }
                if (location == StandardLocation.CLASS_PATH) {
                    String rv = this.delegate.inferBinaryName(location, file);
                    this.log("inferBinaryName location=" + location + " jfo " + file + " rv=" + rv);
                    return rv;
                }
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean isSameFile(FileObject a, FileObject b) {
                this.log("isSameFile");
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean handleOption(String current, Iterator<String> remaining) {
                this.log("handleOption");
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean hasLocation(JavaFileManager.Location location) {
                this.log("hasLocation");
                if (location == StandardLocation.ANNOTATION_PROCESSOR_PATH) {
                    return false;
                }
                if (location == StandardLocation.SOURCE_PATH) {
                    return true;
                }
                if (location.getName().equals("NATIVE_HEADER_OUTPUT")) {
                    return false;
                }
                throw new UnsupportedOperationException("Not supported yet: hasLocation(location=" + location.getName() + ")");
            }

            @Override
            public OutputClass getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
                if (location == null) {
                    return this.map.get(className);
                }
                throw new UnsupportedOperationException("Not supported yet: getJavaFileForInput(location=" + location.getName() + ")");
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                LOG.log(MyJavaFileManager.class, Level.FINE, "getJavaFileForOutput: location=" + location + " className=" + className + " kind=" + (Object)((Object)kind), null);
                this.map.put(className, new OutputClass(this.store, className));
                return this.map.get(className);
            }

            @Override
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                LOG.log(MyJavaFileManager.class, Level.FINE, "getJavaFileForInput: location=" + location + " packageName=" + packageName + " relativeName=" + relativeName, null);
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
                this.log("getFileForOutput");
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void flush() throws IOException {
                this.log("flush");
            }

            @Override
            public void close() throws IOException {
                this.log("close");
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int isSupportedOption(String option) {
                if (option.equals("--multi-release")) {
                    return -1;
                }
                this.log("isSupportedOption");
                throw new UnsupportedOperationException("Not supported yet: isSupportedOption(" + option + ")");
            }

            private static class OutputClass
            implements JavaFileObject {
                private Store store;
                private String name;

                OutputClass(Store store, String name) {
                    this.store = store;
                    this.name = name;
                }

                Code.Loader.Resource toCodeSourceFile() {
                    final OutputClass compiled = this;
                    return new Code.Loader.Resource(){

                        @Override
                        public Code.Loader.URI getURI() {
                            return Code.Loader.URI.create(compiled.toUri());
                        }

                        @Override
                        public String getSourceName() {
                            return null;
                        }

                        @Override
                        public InputStream getInputStream() {
                            try {
                                return compiled.openInputStream();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        public Long getLength() {
                            return null;
                        }

                        @Override
                        public Date getLastModified() {
                            return null;
                        }
                    };
                }

                @Override
                public JavaFileObject.Kind getKind() {
                    return JavaFileObject.Kind.CLASS;
                }

                @Override
                public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public NestingKind getNestingKind() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Modifier getAccessLevel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public URI toUri() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public String getName() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public InputStream openInputStream() throws IOException {
                    return this.store.read(this.name).getInputStream();
                }

                @Override
                public OutputStream openOutputStream() throws IOException {
                    return this.store.createOutputStream(this.name);
                }

                @Override
                public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Writer openWriter() throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public long getLastModified() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean delete() {
                    this.store.remove(this.name);
                    return true;
                }
            }

            private static class InputClass
            implements JavaFileObject {
                private Code.Loader.Resource file;
                private String name;

                InputClass(Code.Loader.Resource file, String name) {
                    this.file = file;
                    this.name = name;
                }

                String binaryName() {
                    return this.name;
                }

                public String toString() {
                    return "InputClass: " + this.file;
                }

                @Override
                public JavaFileObject.Kind getKind() {
                    LOG.log(InputClass.class, Level.FINE, "getKind", null);
                    return JavaFileObject.Kind.CLASS;
                }

                @Override
                public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "isNameCompatible(" + simpleName + "," + (Object)((Object)kind) + ")", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public NestingKind getNestingKind() {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "getNestingKind", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Modifier getAccessLevel() {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "getAccessLevel", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public URI toUri() {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "toUri", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public String getName() {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "getName", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public InputStream openInputStream() throws IOException {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "openInputStream", null);
                    return this.file.getInputStream();
                }

                @Override
                public OutputStream openOutputStream() throws IOException {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "openOutputStream", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "openReader", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "getCharContent", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Writer openWriter() throws IOException {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "openWriter", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public long getLastModified() {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "getLastModified", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean delete() {
                    LOG.log(MyJavaFileManager.class, Level.FINE, "delete", null);
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
        }
    }

    private static class SourceFileObject
    implements JavaFileObject {
        private Streams streams = new Streams();
        private Code.Loader.Resource delegate;

        SourceFileObject(Code.Loader.Resource delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return "SourceFileObject: uri=" + this.toUri() + " name=" + this.getName();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.SOURCE;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            if (simpleName.equals("package-info")) {
                return false;
            }
            if (kind == JavaFileObject.Kind.SOURCE) {
                String slashed = this.delegate.getSourceName().replace("\\", "/");
                String basename = slashed.substring(slashed.lastIndexOf("/") + 1);
                String className = basename.substring(0, basename.length() - ".java".length());
                return className.equals(simpleName);
            }
            throw new UnsupportedOperationException("simpleName = " + simpleName + " kind=" + (Object)((Object)kind));
        }

        @Override
        public NestingKind getNestingKind() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Modifier getAccessLevel() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public URI toUri() {
            return this.delegate.getURI().adapt();
        }

        @Override
        public String getName() {
            return this.delegate.getSourceName();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.streams.readString(this.delegate.getInputStream());
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

