/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.movement.MovementFactory;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.movement.MovementType;
import florent.XSeries.patterns.Blackboard;
import florent.XSeries.patterns.KnowledgeSource;
import java.awt.Graphics2D;
import java.util.Iterator;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackboardMovement
extends MovementStrategy {
    private Blackboard<MovementStrategy> blackboard = new Blackboard();
    private MovementStrategy movement;

    public BlackboardMovement() {
        MovementFactory factory = MovementFactory.getInstance();
        this.blackboard.attachKnowledgeSource(factory.getStrategy(MovementType.WAVESURFINGMOVEMENT));
        this.blackboard.attachKnowledgeSource(factory.getStrategy(MovementType.MIRRORMOVEMENT));
        this.blackboard.attachKnowledgeSource(factory.getStrategy(MovementType.RAMMOVEMENT));
        this.blackboard.attachKnowledgeSource(factory.getStrategy(MovementType.ANTIGRAVITYMOVEMENT));
        this.blackboard.update();
        this.movement = this.blackboard.inspect();
    }

    @Override
    public void endRound() {
        Iterator<MovementStrategy> it = this.blackboard.sourceIterator();
        while (it.hasNext()) {
            it.next().endRound();
        }
    }

    @Override
    public void execAction() {
        this.movement.execAction();
    }

    @Override
    public void execCondition() {
        this.movement.execCondition();
    }

    @Override
    public void initRound() {
        Iterator<MovementStrategy> it = this.blackboard.sourceIterator();
        while (it.hasNext()) {
            it.next().initRound();
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        this.movement.onBulletHit(e);
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.movement.onBulletHitBullet(e);
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
        this.movement.onBulletMissed(e);
    }

    @Override
    public void onDeath(DeathEvent e) {
        this.blackboard.update();
        this.movement = this.blackboard.inspect();
        this.movement.onDeath(e);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        this.movement.onHitByBullet(e);
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        this.movement.onHitRobot(e);
    }

    @Override
    public void onHitWall(HitWallEvent e) {
        this.movement.onHitWall(e);
    }

    @Override
    public void onMainLoop() {
        this.blackboard.update();
        this.movement = this.blackboard.inspect();
        this.movement.onMainLoop();
    }

    @Override
    public void onPaint(Graphics2D e) {
        this.movement.onPaint(e);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        this.movement.onRobotDeath(e);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.movement.onScannedRobot(e);
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
        this.movement.onSkippedTurn(e);
    }

    @Override
    public void onWin(WinEvent e) {
        this.movement.onWin(e);
    }

    @Override
    public void updateBlackboard(Blackboard<? extends KnowledgeSource> blackboard) {
        this.movement.updateBlackboard(blackboard);
    }
}

