/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.debug.Debug;
import pedersen.misc.Persistence;
import pedersen.misc.VaultBase;
import pedersen.opponent.OpponentProfile;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;

public class OpponentLibrary
extends VaultBase {
    public static final OpponentLibrary singleton = new OpponentLibrary();
    private static final String preloadedFile = "oldprofiles";
    private static final String educationFile = "newprofiles";
    private static int profilesLoaded = 0;
    private static int profilesSaved = 0;

    private OpponentLibrary() {
    }

    public OpponentProfile findByTarget(Target target) {
        OpponentProfile vaultEntryMatch = null;
        Iterator iterator = this.iterator();
        while (vaultEntryMatch == null && iterator.hasNext()) {
            OpponentProfile vaultEntry = (OpponentProfile)iterator.next();
            if (!vaultEntry.equals(target)) continue;
            vaultEntryMatch = vaultEntry;
        }
        return vaultEntryMatch;
    }

    public OpponentProfile findByName(String name) {
        OpponentProfile vaultEntryMatch = null;
        Iterator iterator = this.iterator();
        while (vaultEntryMatch == null && iterator.hasNext()) {
            OpponentProfile vaultEntry = (OpponentProfile)iterator.next();
            if (!vaultEntry.equals(name)) continue;
            vaultEntryMatch = vaultEntry;
        }
        return vaultEntryMatch;
    }

    private void load(String filename) {
        List profiles = Persistence.singleton.readListFromFile(filename);
        Iterator iterator = profiles.iterator();
        while (iterator.hasNext()) {
            String name;
            String profile = (String)iterator.next();
            int index = profile.indexOf(";");
            if (index <= 0 || this.findByName(name = profile.substring(0, index)) != null) continue;
            this.add(new OpponentProfile(profile));
            ++profilesLoaded;
        }
    }

    private void save(String filename) {
        if (profilesLoaded > 0) {
            ArrayList<String> profiles = new ArrayList<String>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                profiles.add(((OpponentProfile)iterator.next()).getProfile());
                ++profilesSaved;
            }
            Persistence.singleton.writeListToFile(filename, profiles);
        }
    }

    public void synchronize(Target target) {
        OpponentProfile opponentProfile = this.findByTarget(target);
        if (opponentProfile == null) {
            opponentProfile = new OpponentProfile(target);
            this.add(opponentProfile);
        }
        opponentProfile.synchronize(target);
    }

    public void synchronizeWithTargetBank() {
        Iterator iterator = TargetBank.singleton.iterator();
        while (iterator.hasNext()) {
            this.synchronize((Target)iterator.next());
        }
    }

    public void setup() {
        try {
            this.purge();
            this.load(educationFile);
            this.load(preloadedFile);
        }
        catch (Exception ex) {
            Debug.exception("OpponentLibrary.setup()", ex);
        }
    }

    public void teardown() {
        try {
            this.setup();
            this.synchronizeWithTargetBank();
            this.save(educationFile);
            this.purge();
        }
        catch (Exception ex) {
            Debug.exception("OpponentLibrary.teardown()", ex);
        }
    }

    public void debug() {
        Debug.debug("Profiles loaded: " + profilesLoaded);
        Debug.debug("Profiles saved: " + profilesSaved);
    }
}

