/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import java.util.Iterator;
import pedersen.divination.CombatWave;
import pedersen.divination.WaveData;
import pedersen.divination.WaveInboundBank;
import pedersen.misc.Metrics;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.tactics.grail.WaveAnalysis;
import pedersen.tactics.movement.MovementMethodBase;

public abstract class MovementMethodSurferBase2
extends MovementMethodBase {
    private long inboundWaveCount = 0L;
    protected CombatWave presentInterceptWave = null;
    protected StaticPosition presentInterceptPosition = null;

    public MovementMethodSurferBase2(int newPersistenceId) {
        super(newPersistenceId);
    }

    protected void accountForAllWaves(StaticPosition position, long time) {
        if (Metrics.getInboundWaveCount() > this.inboundWaveCount || this.presentInterceptWave == null || !this.presentInterceptWave.isActive()) {
            this.inboundWaveCount = Metrics.getInboundWaveCount();
            this.presentInterceptWave = this.getFirstWaveToImpact(position, time);
            if (this.presentInterceptWave != null) {
                WaveAnalysis waveAnalysis = this.presentInterceptWave.getWaveAnalysis();
                WaveData waveData = this.presentInterceptWave.getWaveData();
                double bearingOffset = waveAnalysis.getLeastVisitedFiringAngle(waveData);
                this.presentInterceptPosition = this.generateInterceptPosition(this.presentInterceptWave, position, bearingOffset);
            }
        }
    }

    protected CombatWave getFirstWaveToImpact(StaticPosition position, long time) {
        CombatWave firstWaveToImpact = null;
        double firstWaveTimeToImpact = 0.0;
        Iterator iterator = WaveInboundBank.singleton.iterator();
        while (iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            double timeToImpact = wave.getDistance(position) - wave.getRadius(time) / wave.getVelocity();
            if (firstWaveToImpact != null && !(timeToImpact < firstWaveTimeToImpact)) continue;
            firstWaveToImpact = wave;
            firstWaveTimeToImpact = timeToImpact;
        }
        return firstWaveToImpact;
    }

    private StaticPosition generateInterceptPosition(StaticPosition firingPosition, StaticPosition target, double bearingOffset) {
        double bearingToIntercept = firingPosition.getBearing(target) + bearingOffset;
        double distanceToIntercept = 36.0 + firingPosition.getDistance(target) * Math.cos(bearingOffset);
        return new StaticPositionImpl(firingPosition, bearingToIntercept, distanceToIntercept);
    }
}

