/*
 * Decompiled with CFR 0.152.
 */
package ara;

import ara.EnemySub;
import ara.Shera;
import ara.Statistic;
import ara.Util;
import ara.VBullet;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.ScannedRobotEvent;

public class Enemy {
    public Shera shera;
    String Name;
    boolean Dead;
    LinkedList List;
    double X;
    double Y;
    double Energy;
    double Bearing;
    double Distance;
    double Heading;
    double Velocity;
    double NX;
    double NY;
    double NH;
    double NV;
    double DamageFrom = 0.0;
    double DamageTo = 0.0;
    long LastScan;
    double OldX;
    double OldY;
    long OldLastScan = Long.MAX_VALUE;
    int StraightCount = 0;
    public double LastHeading = 0.0;
    double LastVel = 0.0;
    boolean Shoot;
    Statistic StatTo;
    Statistic StatFrom;
    double AveVel = 4.0;
    double AveHead = 0.0;
    int Accel = 0;
    int Stop = 0;
    double LastDH = 0.0;
    int DHCount = 0;
    double AveDH = 0.0;
    boolean GuruGuru = false;
    boolean KuneKune = false;
    long StayCount = 0L;
    double AveAbsVel = 4.0;
    double[] Factor;
    double[][] VBRatio;
    double[] AveVBRatio;
    LinkedList VB;
    long[] nVB;
    long nVBTotal;

    void Update(ScannedRobotEvent e) {
        double sx = this.shera.getX();
        double sy = this.shera.getY();
        double d = e.getDistance();
        double b = 90.0 - e.getBearing() - this.shera.getHeading();
        double dv = Math.abs(this.Velocity) - Math.abs(e.getVelocity());
        if (dv < 0.0) {
            this.Accel = 1;
        }
        if (dv > 0.0) {
            this.Accel = -1;
        }
        if (Math.abs(dv) < 0.5) {
            this.Accel = 0;
        }
        double oldenergy = this.Energy;
        this.LastHeading = this.Heading;
        this.LastVel = this.Velocity;
        this.OldX = this.X;
        this.OldY = this.Y;
        this.OldLastScan = this.LastScan;
        this.X = sx + Util.cosDeg(b) * d;
        this.Y = sy + Util.sinDeg(b) * d;
        this.LastScan = this.shera.Time;
        this.Energy = e.getEnergy();
        this.Bearing = e.getBearing();
        this.Distance = e.getDistance();
        this.Heading = e.getHeading();
        this.Velocity = e.getVelocity();
        if (this.Energy < 0.0) {
            this.Dead = true;
        }
        this.AveVel = Util.PseudoAve(this.AveVel, 20.0, this.Velocity);
        this.UpdateAveHead();
        this.StayCount = Util.Dist(this.OldX, this.OldY, this.X, this.Y) < (double)(2L * (this.LastScan - this.OldLastScan)) ? (this.StayCount += this.LastScan - this.OldLastScan) : 0L;
        double difenergy = this.Energy - oldenergy;
        if (difenergy <= -0.1 && difenergy >= -3.0) {
            ++this.StatFrom.nMiss;
            this.Shoot = true;
            this.StatFrom.Power -= difenergy;
            double c = (1.0 - difenergy / 5.0) / this.shera.getGunCoolingRate();
        } else {
            this.Shoot = false;
        }
        EnemySub sub = new EnemySub(this.X, this.Y, this.LastScan, this.Energy, this.Bearing, this.Distance, this.Heading, this.Velocity);
        this.List.addLast(sub);
        if (this.List.size() > 10) {
            this.List.removeFirst();
        }
        this.Stop = this.isStop();
        double vel = this.VelVB();
        double eh = this.HeadVB();
        double w = 1.0;
        if (this.shera.Time - this.shera.firing.LastFire < 5L) {
            w = 5.0;
        }
        int num = VBullet.GetNumber(this.Stop, this.Distance, this.shera.nBot != 1);
        if (!this.GuruGuru) {
            int i = 0;
            while (i < 11) {
                double v = vel * this.Factor[i];
                Point2D.Double p = this.shera.firing.GetTargetPosLineSub2(this, 3.0, v, eh);
                if (this.shera.CheckCoord(p, -10.0)) {
                    VBullet vb = new VBullet(sx, sy, p.x, p.y, 3.0, this.LastScan, i, this.Stop, w, this.shera.nBot != 1);
                    this.VB.addLast(vb);
                    int n = num;
                    this.nVB[n] = this.nVB[n] + 1L;
                    ++this.nVBTotal;
                }
                ++i;
            }
        }
        this.UpdateVB();
        this.PredNext();
    }

    private void UpdateVB() {
        long t = this.shera.Time;
        boolean f = false;
        do {
            f = false;
            if (this.VB.size() == 0) break;
            VBullet vb = (VBullet)this.VB.getFirst();
            if (this.shera.CheckCoord(vb.GetBulPos(t), 0.0) && t <= vb.Expire && !vb.Cheaked) continue;
            f = true;
            int vbn = vb.GetNumber();
            this.VBRatio[vbn][vb.Index] = Util.PseudoAve(this.VBRatio[vbn][vb.Index], 50.0 / vb.Weight, 0.0);
            this.AveVBRatio[vbn] = Util.PseudoAve(this.AveVBRatio[vbn], 50.0 / vb.Weight, 0.0);
            this.VB.removeFirst();
        } while (f);
        if (t - this.OldLastScan < 10L) {
            long i = this.OldLastScan + 1L;
            while (i <= t) {
                double x = this.OldX + (this.X - this.OldX) * (double)(i - this.OldLastScan) / (double)(t - this.OldLastScan);
                double y = this.OldY + (this.Y - this.OldY) * (double)(i - this.OldLastScan) / (double)(t - this.OldLastScan);
                ListIterator ite = (ListIterator)this.VB.iterator();
                while (ite.hasNext()) {
                    VBullet vb = (VBullet)ite.next();
                    if (vb.Cheaked || !vb.isHit(i, x, y)) continue;
                    Point2D.Double p = vb.GetBulPos(i);
                    if (this.shera.CheckCoord(p, -10.0)) {
                        int vbn = vb.GetNumber();
                        this.VBRatio[vbn][vb.Index] = Util.PseudoAve(this.VBRatio[vbn][vb.Index], 50.0 / vb.Weight, 1.0);
                        this.AveVBRatio[vbn] = Util.PseudoAve(this.AveVBRatio[vbn], 50.0 / vb.Weight, 1.0);
                    }
                    vb.Cheaked = true;
                }
                ++i;
            }
        } else {
            this.VB.clear();
        }
    }

    private void PredNext() {
        double h = 90.0 - this.Heading;
        this.NX = this.X + Util.cosDeg(h) * this.Velocity;
        this.NY = this.Y + Util.sinDeg(h) * this.Velocity;
    }

    Enemy(String name, Shera s) {
        this.shera = s;
        this.Name = name;
        this.Dead = false;
        this.List = new LinkedList();
        this.DamageFrom = 0.0;
        this.StatTo = new Statistic();
        this.StatFrom = new Statistic();
        this.VB = new LinkedList();
        this.Factor = new double[11];
        this.VBRatio = new double[16][11];
        this.AveVBRatio = new double[16];
        this.nVB = new long[16];
        int i = 0;
        while (i < 16) {
            this.nVB[i] = 0L;
            ++i;
        }
        this.nVBTotal = 0L;
        i = 0;
        while (i < 11) {
            int j = 0;
            while (j < 16) {
                this.VBRatio[j][i] = 0.1;
                ++j;
            }
            this.Factor[i] = 1.0 - (double)i * 2.0 / 10.0;
            ++i;
        }
        int j = 0;
        while (j < 16) {
            this.VBRatio[j][5] = 0.101;
            this.AveVBRatio[j] = 0.1;
            ++j;
        }
    }

    void ReadStat() {
    }

    void WriteStat() {
    }

    double HeadingDef() {
        double d = this.Heading;
        if (this.List.size() < 2) {
            return 0.0;
        }
        EnemySub eb = (EnemySub)this.List.get(this.List.size() - 2);
        long dt = this.LastScan - eb.Time;
        return Util.normalDegB(d - eb.Heading) / (double)dt;
    }

    public double AveAbsSpeed() {
        double v = 0.0;
        ListIterator ite = (ListIterator)this.List.iterator();
        while (ite.hasNext()) {
            EnemySub s = (EnemySub)ite.next();
            v += Math.abs(s.Velocity);
        }
        v /= (double)this.List.size();
        if (this.Velocity < 0.0) {
            v = -v;
        }
        return v;
    }

    public double AveSpeed() {
        double v = 0.0;
        ListIterator ite = (ListIterator)this.List.iterator();
        while (ite.hasNext()) {
            EnemySub s = (EnemySub)ite.next();
            v += s.Velocity;
        }
        return v /= (double)this.List.size();
    }

    public Point2D.Double AveragePos() {
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        ListIterator ite = (ListIterator)this.List.iterator();
        while (ite.hasNext()) {
            EnemySub s = (EnemySub)ite.next();
            p.x += s.X;
            p.y += s.Y;
        }
        p.x /= (double)this.List.size();
        p.y /= (double)this.List.size();
        return p;
    }

    private void UpdateAveHead() {
        double h = Util.normalDegA(90.0 - this.Heading);
        this.AveHead = Util.normalDegA(this.AveHead);
        if (h > this.AveHead + 180.0) {
            h -= 360.0;
        }
        if (h < this.AveHead - 180.0) {
            h += 360.0;
        }
        this.AveHead = Util.PseudoAve(this.AveHead, 2.0, h);
        double dh = Util.normalDegB(this.Heading - this.LastHeading);
        if (Math.abs(dh - this.LastDH) < 5.0) {
            ++this.DHCount;
            if (this.DHCount > 100 && Math.abs(dh) > 3.0) {
                this.GuruGuru = true;
            }
        } else {
            this.DHCount = 0;
            this.GuruGuru = false;
        }
        this.AveDH = Util.PseudoAve(this.AveDH, 50.0, Math.abs(dh));
        this.KuneKune = this.AveDH > 5.0;
        this.LastDH = dh;
        this.AveAbsVel = Util.PseudoAve(this.AveAbsVel, 300.0, Math.abs(this.Velocity));
        this.StraightCount = Math.abs(dh) < 5.0 && Math.abs(this.LastVel - this.Velocity) < 2.0 && Math.abs(this.Velocity) > 2.0 ? (int)((long)this.StraightCount + (this.LastScan - this.OldLastScan)) : 0;
    }

    public boolean Straight() {
        return this.StraightCount > 10;
    }

    public double VelVB() {
        double vel = 8.0;
        vel = this.isStop() == 1 ? (this.AveVel > 0.0 ? 8.0 : -8.0) : (this.Velocity > 0.0 ? 8.0 : -8.0);
        return vel;
    }

    public double HeadVB() {
        double eh = Util.normalDegA(90.0 - this.Heading);
        if (this.KuneKune) {
            eh = this.AveHead;
        }
        return eh;
    }

    public int isStop() {
        if (this.Velocity == 0.0) {
            return 1;
        }
        if (this.Accel == -1) {
            return 1;
        }
        return 0;
    }

    public double AveRatio() {
        return this.AveVBRatio[VBullet.GetNumber(this.Stop, this.Distance, this.shera.nBot != 1)];
    }

    public int Roulette(double[] v, double p) {
        double[] b = new double[v.length];
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < v.length) {
            sum1 += v[i];
            ++i;
        }
        i = 0;
        while (i < v.length) {
            b[i] = Math.pow(v[i] / sum1, p);
            sum2 += b[i];
            ++i;
        }
        double r = Math.random() * sum2;
        int i2 = 0;
        while (i2 < b.length) {
            if (r < b[i2]) {
                return i2;
            }
            r -= b[i2];
            ++i2;
        }
        return 0;
    }

    public int Roulette2() {
        int num = VBullet.GetNumber(this.Stop, this.Distance, this.shera.nBot != 1);
        double[] v = this.VBRatio[num];
        double[] b = new double[v.length];
        double sum = 0.0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < v.length) {
            if (min > v[i]) {
                min = v[i];
            }
            ++i;
        }
        i = 0;
        while (i < v.length) {
            b[i] = v[i] - min;
            b[i] = Math.pow(b[i], 2.0);
            sum += b[i];
            ++i;
        }
        double r = Math.random() * sum;
        int i2 = 0;
        while (i2 < b.length) {
            if (r < b[i2]) {
                return i2;
            }
            r -= b[i2];
            ++i2;
        }
        return 0;
    }

    public int Best() {
        int num = VBullet.GetNumber(this.Stop, this.Distance, this.shera.nBot != 1);
        double[] v = this.VBRatio[num];
        double max = 0.0;
        int best = 0;
        int i = 0;
        while (i < v.length) {
            if (max < v[i]) {
                max = v[i];
                best = i;
            }
            ++i;
        }
        return best;
    }

    public boolean Stay() {
        boolean r = this.StayCount > 40L;
        return r;
    }

    public void Print() {
        DecimalFormat f1 = new DecimalFormat("0.0");
        DecimalFormat f2 = new DecimalFormat("00.00");
        DecimalFormat f3 = new DecimalFormat("0000000");
        int i = 0;
        while (i < 11) {
            String s = "  ";
            int j = 0;
            while (j < 16) {
                s = String.valueOf(s) + f2.format(this.VBRatio[j][i] * 100.0) + "   ";
                ++j;
            }
            this.shera.out(s);
            ++i;
        }
        this.shera.out("----------------------------------------------------------------");
        String s = "";
        int j = 0;
        while (j < 16) {
            s = String.valueOf(s) + f3.format(this.nVB[j]) + " ";
            ++j;
        }
        this.shera.out(s);
        s = " ";
        j = 0;
        while (j < 16) {
            s = String.valueOf(s) + f2.format((double)this.nVB[j] / (double)this.nVBTotal * 100.0) + "%  ";
            this.nVB[j] = 0L;
            ++j;
        }
        this.nVBTotal = 0L;
        this.shera.out(s);
        s = " ";
        j = 0;
        while (j < 16) {
            s = String.valueOf(s) + f2.format(this.AveVBRatio[j] * 100.0) + "%  ";
            ++j;
        }
        this.shera.out(s);
    }

    public void Reset() {
        this.VB.clear();
        this.StayCount = 0L;
    }
}

