/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.Location;
import java.util.Arrays;

public class LocationLog {
    private Location[] locations;
    private boolean noLocationsYet;
    private int sizeIncrement;
    private int previousTime;

    public LocationLog(int initialSize, int increment) {
        this.locations = new Location[initialSize];
        this.noLocationsYet = true;
        this.sizeIncrement = increment;
        this.previousTime = -1;
    }

    public void record(Location location, int time) {
        if (time >= this.locations.length) {
            this.locations = Arrays.copyOf(this.locations, Math.max(this.locations.length + this.sizeIncrement, time + 1));
        }
        this.locations[time] = location;
        if (this.noLocationsYet) {
            this.repeatInitialLocation(location, time);
        } else {
            this.insertGuesses(location, time);
        }
        this.previousTime = time;
        this.noLocationsYet = false;
    }

    private void repeatInitialLocation(Location location, int time) {
        for (int i = 0; i < time; ++i) {
            this.locations[i] = location;
        }
    }

    private void insertGuesses(Location location, int time) {
        long timeGap = time - this.previousTime;
        if (timeGap > 1L) {
            double xDiff = (location.getX() - this.locations[this.previousTime].getX()) / (double)timeGap;
            double yDiff = (location.getY() - this.locations[this.previousTime].getY()) / (double)timeGap;
            Location guess = this.locations[this.previousTime];
            for (int t = this.previousTime + 1; t < time; ++t) {
                this.locations[t] = guess = new Location(guess.getX() + xDiff, guess.getY() + yDiff);
            }
        }
    }

    public Location getAtTime(int time) {
        if (time < this.locations.length) {
            return this.locations[time];
        }
        return null;
    }
}

