/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.ConvertStatistic;
import dmh.robocode.utils.Geometry;

public abstract class Shot {
    public static byte unknownObservationAge = (byte)-1;
    public static byte unknownEnemyZone = (byte)-1;
    public static short unknownEnemyDistance = (short)-1;
    private byte observationAge;
    private byte enemyZone;
    private byte myZone;
    private byte numberOfLiveEnemies;
    private byte bulletPowerTimesTen;
    private short enemyDistance;
    private int roundNum;
    private EnemyRobot enemy;

    public Shot(CommandBasedRobot myRobot, EnemyRobot enemyRobot, double bulletPower) {
        RadarObservation enemyObservation = enemyRobot.getLatestRadarObservation();
        Location myLocation = myRobot.getLocation();
        if (enemyObservation == null) {
            this.observationAge = unknownObservationAge;
            this.enemyZone = unknownEnemyZone;
            this.enemyDistance = unknownEnemyDistance;
        } else {
            this.observationAge = ConvertStatistic.makeByte(myRobot.getTime() - enemyObservation.getTimeSeen());
            this.enemyZone = enemyObservation.getLocation().getZone(myRobot.getBattleFieldWidth(), myRobot.getBattleFieldHeight());
            this.enemyDistance = ConvertStatistic.makeShort(Geometry.getDistanceBetweenLocations(myLocation, enemyObservation.getLocation()));
        }
        this.myZone = myLocation.getZone(myRobot.getBattleFieldWidth(), myRobot.getBattleFieldHeight());
        this.numberOfLiveEnemies = ConvertStatistic.makeByte(myRobot.getOthers());
        this.bulletPowerTimesTen = ConvertStatistic.makeByte(bulletPower * 10.0);
        this.enemy = enemyRobot;
        this.roundNum = myRobot.getRoundNum();
    }

    public byte getObservationAge() {
        return this.observationAge;
    }

    public byte getEnemyZone() {
        return this.enemyZone;
    }

    public byte getMyZone() {
        return this.myZone;
    }

    public byte getNumberOfLiveEnemies() {
        return this.numberOfLiveEnemies;
    }

    public double getBulletPower() {
        return (double)this.bulletPowerTimesTen / 10.0;
    }

    public short getEnemyDistance() {
        return this.enemyDistance;
    }

    public int getRoundNum() {
        return this.roundNum;
    }

    public EnemyRobot getEnemy() {
        return this.enemy;
    }
}

