/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.utils;

import robocode.util.Utils;

public class BearingSelector {
    int granularity;
    double[] highScores;
    double[] lowScores;

    public BearingSelector(int granularity) {
        this.granularity = granularity;
        this.highScores = new double[360 / granularity];
        this.lowScores = new double[360 / granularity];
    }

    public double getHighScoreBearing() {
        int highIndex = 0;
        double highScore = this.highScores[highIndex];
        for (int i = 1; i < this.highScores.length; ++i) {
            if (!(this.highScores[i] > highScore)) continue;
            highScore = this.highScores[i];
            highIndex = i;
        }
        return highIndex * this.granularity;
    }

    public double getLowScoreBearing() {
        int lowIndex = 0;
        double lowScore = this.lowScores[lowIndex];
        for (int i = 1; i < this.lowScores.length; ++i) {
            if (!(this.lowScores[i] < lowScore)) continue;
            lowScore = this.lowScores[i];
            lowIndex = i;
        }
        return lowIndex * this.granularity;
    }

    public void add(double bearing, double score) {
        int bearingIndex = this.fixScoreIndex((int)Math.round(Utils.normalAbsoluteAngleDegrees((double)bearing) / (double)this.granularity));
        double highScore = score;
        double lowScore = score;
        double highScoreReduction = score / 100.0;
        double lowScoreReduction = score / 100.0;
        int n = bearingIndex;
        this.highScores[n] = this.highScores[n] + highScore;
        int n2 = bearingIndex;
        this.lowScores[n2] = this.lowScores[n2] + lowScore;
        for (int i = 1; i < this.highScores.length / 2; ++i) {
            lowScore -= lowScoreReduction;
            lowScoreReduction *= 0.9;
            int n3 = this.fixScoreIndex(bearingIndex + i);
            this.highScores[n3] = this.highScores[n3] + (highScore -= (highScoreReduction *= 1.1));
            int n4 = this.fixScoreIndex(bearingIndex - i);
            this.highScores[n4] = this.highScores[n4] + highScore;
            int n5 = this.fixScoreIndex(bearingIndex + i);
            this.lowScores[n5] = this.lowScores[n5] + lowScore;
            int n6 = this.fixScoreIndex(bearingIndex - i);
            this.lowScores[n6] = this.lowScores[n6] + lowScore;
        }
        int n7 = this.fixScoreIndex(bearingIndex + this.highScores.length / 2);
        this.highScores[n7] = this.highScores[n7] + (highScore - highScoreReduction);
        int n8 = this.fixScoreIndex(bearingIndex + this.highScores.length / 2);
        this.lowScores[n8] = this.lowScores[n8] + (lowScore - lowScoreReduction);
    }

    private int fixScoreIndex(int index) {
        if (index >= this.highScores.length) {
            index -= this.highScores.length;
        } else if (index < 0) {
            index += this.highScores.length;
        }
        return index;
    }
}

