/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.TreeMap;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import wcsv.melee.BasicInfo;
import wcsv.melee.Gun;
import wcsv.melee.Info;
import wcsv.melee.InfoSet;
import wcsv.melee.MeleeNeuralNetGun;
import wcsv.melee.MinimumRiskMove;
import wcsv.melee.Move;
import wcsv.melee.Utils;

public class RobotController {
    private TeamRobot robot;
    private Gun _gun;
    private Move _move;
    private ArrayList scans;
    private BasicInfo myBasicInfo;
    private TreeMap infoSets;
    private InfoSet target;
    private boolean sweepingRadar;

    public void run() {
        this.myBasicInfo.update(this.robot);
        int i = 0;
        while (i < this.scans.size()) {
            ScannedRobotEvent scan = (ScannedRobotEvent)this.scans.get(i);
            InfoSet set = (InfoSet)this.infoSets.get(scan.getName());
            if (set == null) {
                set = new InfoSet();
                set.enemy = new Info(scan, this.robot);
                set.myInfo = new Info(this.myBasicInfo, scan);
                this.infoSets.put(scan.getName(), set);
            } else {
                set.enemy.update(scan, this.robot);
                set.myInfo.update(this.myBasicInfo, scan);
            }
            if (this.target == null || set.enemy.distance < 0.65 * this.target.enemy.distance) {
                this.target = set;
            }
            this._gun.registerScan(set, this.target);
            this._move.registerScan(set);
            ++i;
        }
        this.scans.clear();
        if (this.robot.getOthers() == 1) {
            this.radarLock(this.target);
            this._gun.operate(this.target);
        } else if (this._gun.operate(this.target)) {
            this.robot.setTurnRadarRightRadians(Math.PI * 2);
            this.sweepingRadar = true;
        } else if (!this.sweepingRadar || this.sweepingRadar && Math.abs(this.robot.getRadarTurnRemainingRadians()) < 0.01) {
            this.radarLock(this.target);
            this.sweepingRadar = false;
        }
        this._move.operate(this.target);
        this.robot.execute();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.scans.add(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        InfoSet set = (InfoSet)this.infoSets.get(e.getName());
        if (set != null) {
            set.enemy.basic.tempDamage += Utils.bulletDamage(e.getBullet().getPower());
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onMessageRecieved(MessageEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.infoSets.remove(e.getName());
        if (this.target != null && e.getName().equals(this.target.enemy.basic.name)) {
            this.target = null;
        }
    }

    public void reset() {
        this._gun.reset();
        this._move.reset();
        this.target = null;
        this.infoSets.clear();
        this.sweepingRadar = false;
    }

    public void radarLock(InfoSet target) {
        if (target == null || target.enemy.basic.scanTime <= this.robot.getTime() - (long)3) {
            this.robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        } else {
            double rAngle = Utils.relativeAngle(target.enemy.bearing - this.robot.getRadarHeadingRadians());
            if (rAngle > 0.0) {
                this.robot.setTurnRadarRightRadians(rAngle + 0.1);
            } else {
                this.robot.setTurnRadarRightRadians(rAngle - 0.1);
            }
        }
    }

    public RobotController(TeamRobot r) {
        this.robot = r;
        r.setAdjustRadarForRobotTurn(true);
        r.setAdjustRadarForGunTurn(true);
        r.setAdjustGunForRobotTurn(true);
        Utils.fWidth = r.getBattleFieldWidth();
        Utils.fHeight = r.getBattleFieldHeight();
        Utils.center = new Point2D.Double(Utils.fWidth / (double)2, Utils.fHeight / (double)2);
        this.scans = new ArrayList(this.robot.getOthers());
        this.myBasicInfo = new BasicInfo(this.robot);
        this.infoSets = new TreeMap();
        this._move = new MinimumRiskMove(this.robot);
        this._gun = new MeleeNeuralNetGun((AdvancedRobot)this.robot);
        this.sweepingRadar = false;
    }
}

