/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.navigation;

import ghent.common.Direction;
import ghent.common.Target;
import ghent.modules.Module;
import ghent.modules.navigation.events.NearWallCondition;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.Robot;
import robocode.Rules;
import robocode.util.Utils;

public class Navigator
extends Module {
    private static final int RAM_POWER = 40;
    private static final double RUN_AWAY_DISTANCE = 200.0;
    private static final double LIMIT_DISTANCE_NEAR_WALL = 100.0;

    public Navigator(AdvancedRobot robot) {
        super(robot);
    }

    public void init() {
        super.init();
        this._robot.addCustomEvent((Condition)new NearWallCondition((Robot)this._robot));
    }

    public void dance() {
        for (int i = 0; i < 50; ++i) {
            this._robot.turnRight(30.0);
            this._robot.turnLeft(30.0);
        }
    }

    public void ram(Target target) {
        if (target == null) {
            return;
        }
        Point2D robotLocation = this.getRobotLocation();
        double angle = target.getBearing(robotLocation) - this._robot.getHeading();
        double distance = target.getDistance(robotLocation) + 40.0;
        this.moveTo(angle, distance);
    }

    public void moveTo(double angle, double distance) {
        if ((angle = Utils.normalRelativeAngleDegrees((double)angle)) < -90.0 || angle > 90.0) {
            angle = Utils.normalRelativeAngleDegrees((double)(angle + 180.0));
            distance = -distance;
        }
        this._robot.setTurnRight(angle);
        this._robot.setAhead(distance);
    }

    public void moveTo(Point2D dest) {
        if (dest == null) {
            return;
        }
        Point2D robotLocation = this.getRobotLocation();
        Target destTarget = new Target();
        destTarget.setLocation(dest);
        double angle = Utils.normalRelativeAngleDegrees((double)(destTarget.getBearing(robotLocation) - this._robot.getHeading()));
        this.moveTo(angle, destTarget.getDistance(robotLocation));
    }

    public Point2D getNextPosition() {
        double velocity = this._robot.getVelocity();
        double turnRemaining = this._robot.getTurnRemaining();
        double heading = this._robot.getHeading();
        Point2D position = this.getRobotLocation();
        double maximumTurnRate = Rules.getTurnRate((double)velocity);
        double turnRate = Math.min(turnRemaining, maximumTurnRate);
        double endHeading = heading + turnRate;
        Point2D endPosition = null;
        return endPosition;
    }

    public void runAway() {
        boolean ahead = true;
        Direction d = Direction.getApproximate(this._robot.getHeading());
        switch (d) {
            case WEST: 
            case EAST: 
            case NORTH: 
            case SOUTH: {
                if (!this.nearWall(d)) break;
                ahead = false;
                break;
            }
            case SOUTH_WEST: {
                if (!this.nearWall(Direction.SOUTH) && !this.nearWall(Direction.WEST)) break;
                ahead = false;
                break;
            }
            case SOUTH_EAST: {
                if (!this.nearWall(Direction.SOUTH) && !this.nearWall(Direction.EAST)) break;
                ahead = false;
                break;
            }
            case NORTH_WEST: {
                if (!this.nearWall(Direction.NORTH) && !this.nearWall(Direction.WEST)) break;
                ahead = false;
                break;
            }
            case NORTH_EAST: {
                if (!this.nearWall(Direction.NORTH) && !this.nearWall(Direction.EAST)) break;
                ahead = false;
            }
        }
        if (ahead) {
            this._robot.setAhead(200.0);
        } else {
            this._robot.setBack(200.0);
        }
    }

    private boolean nearWall(Direction wall) {
        boolean res = false;
        switch (wall) {
            case NORTH: {
                res = this._robot.getY() > this._robot.getBattleFieldHeight() - 100.0;
                break;
            }
            case EAST: {
                res = this._robot.getX() > this._robot.getBattleFieldWidth() - 100.0;
                break;
            }
            case SOUTH: {
                res = this._robot.getY() < 100.0;
                break;
            }
            case WEST: {
                res = this._robot.getX() < 100.0;
            }
        }
        return res;
    }

    public static double distanceBeforeStop(double velocity) {
        double dist = 0.0;
        double i = Math.abs(velocity);
        while (i > 0.0) {
            dist += i;
            i = Math.max(0.0, i - 2.0);
        }
        return dist;
    }

    public double distanceBeforeStop() {
        return Navigator.distanceBeforeStop(this._robot.getVelocity());
    }
}

