/*
 * Decompiled with CFR 0.152.
 */
package sanyi.mikrobi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import sanyi.mikrobi.Behavior;
import sanyi.mikrobi.RadarStrategy;
import sanyi.mikrobi.ScannedRobotEventHolder;

public class Roberto
extends AdvancedRobot {
    boolean mayChangeDirection = true;
    int missedCounter = 0;
    int enemyHitCounter = 0;
    RadarStrategy radarStrategy = RadarStrategy.SCAN;
    Map<String, List<ScannedRobotEventHolder>> robots = new HashMap<String, List<ScannedRobotEventHolder>>();
    Map<String, Behavior> behaviours = new HashMap<String, Behavior>();
    Random rnd = new Random(System.currentTimeMillis());
    boolean direction = true;
    double maxX = 0.0;
    double maxY = 0.0;
    String target = null;
    boolean radarScanDirectionLeft = true;
    double radarScanMid = 0.0;
    private boolean notScanned = true;
    volatile double firePower = 2.0;
    private boolean running = true;
    public static final int B = 150;
    public static final int D = 50;

    public void run() {
        this.maxX = this.getBattleFieldWidth();
        this.maxY = this.getBattleFieldHeight();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (this.running) {
            this.radarMgmt();
            this.turningMgmt();
            this.movingMgmt();
            this.analyzeRobots();
            this.selectTarget();
            this.aimingMgmt();
            this.fireMgmt();
            this.execute();
        }
        this.setTurnLeft(this.getHeading());
        this.setTurnGunLeft(this.getGunHeading());
        this.setTurnRadarLeft(this.getRadarHeading());
        while (this.getTurnRemaining() > 1.0 || this.getGunTurnRemaining() > 1.0 || this.getRadarTurnRemaining() > 1.0) {
            this.execute();
        }
    }

    private void radarMgmt() {
        if (this.radarStrategy == RadarStrategy.SCAN || this.target == null || this.radarStrategy == RadarStrategy.TRACK && this.notScanned) {
            if (this.getRadarTurnRemaining() < 10.0) {
                this.setTurnRadarLeft(360.0);
            }
        } else if (this.radarStrategy == RadarStrategy.TRACK && this.getRadarTurnRemaining() < 5.0) {
            if (this.radarScanMid > this.getRadarHeadingRadians()) {
                this.setTurnRadarRightRadians(this.radarScanMid - this.getRadarHeadingRadians() + 0.39269908169872414);
            } else {
                this.setTurnRadarLeftRadians(this.getRadarHeadingRadians() - this.radarScanMid + 0.39269908169872414);
            }
            this.notScanned = true;
        }
    }

    private void fireMgmt() {
        if (this.getGunTurnRemaining() < 1.0 && this.target != null) {
            this.fire(this.firePower);
        }
    }

    private void selectTarget() {
        ScannedRobotEventHolder closest = null;
        ScannedRobotEventHolder closestStays = null;
        ScannedRobotEventHolder closestSteadyMove = null;
        ScannedRobotEventHolder selected = null;
        for (Map.Entry<String, List<ScannedRobotEventHolder>> entry : this.robots.entrySet()) {
            String robotName = entry.getKey();
            ScannedRobotEventHolder value = entry.getValue().get(0);
            if (this.behaviours.get(robotName) == Behavior.STAYS) {
                if (closestStays == null) {
                    closestStays = value;
                } else if (closestStays.sre.getDistance() > value.sre.getDistance()) {
                    closestStays = value;
                }
            } else if (this.behaviours.get(robotName) == Behavior.STEADYMOVE) {
                if (closestSteadyMove == null) {
                    closestSteadyMove = value;
                } else if (closestSteadyMove.sre.getDistance() > value.sre.getDistance()) {
                    closestSteadyMove = value;
                }
            }
            if (closest == null) {
                closest = value;
                continue;
            }
            if (!(closest.sre.getDistance() > value.sre.getDistance())) continue;
            closest = value;
        }
        if (closestStays != null) {
            selected = closestStays;
            this.radarStrategy = RadarStrategy.SCAN;
        } else if (closestSteadyMove != null) {
            selected = closestSteadyMove;
            this.radarStrategy = RadarStrategy.SCAN;
        } else if (closest != null) {
            selected = closest;
            this.radarStrategy = RadarStrategy.TRACK;
        }
        if (closest != null && selected != closest && closest.sre.getDistance() < 80.0) {
            selected = closest;
            this.radarStrategy = RadarStrategy.TRACK;
        }
        if (this.getOthers() == 1) {
            this.radarStrategy = RadarStrategy.TRACK;
        }
        if (selected != null) {
            this.target = selected.sre.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeRobots() {
        this.behaviours.clear();
        Map<String, List<ScannedRobotEventHolder>> map = this.robots;
        synchronized (map) {
            for (Map.Entry<String, List<ScannedRobotEventHolder>> entry : this.robots.entrySet()) {
                String robotName = entry.getKey();
                List<ScannedRobotEventHolder> lst = entry.getValue();
                double[][] positions = new double[Math.min(lst.size(), 2)][2];
                int i = 0;
                while (i < positions.length) {
                    positions[i][0] = lst.get((int)i).x;
                    positions[i][1] = lst.get((int)i).y;
                    ++i;
                }
                if (positions.length >= 2) {
                    boolean xStays = false;
                    if (Math.abs(positions[0][0] - positions[1][0]) < 5.0) {
                        xStays = true;
                    }
                    boolean yStays = false;
                    if (Math.abs(positions[0][1] - positions[1][1]) < 5.0) {
                        yStays = true;
                    }
                    if (xStays && yStays) {
                        this.behaviours.put(robotName, Behavior.STAYS);
                        continue;
                    }
                }
                if (lst.size() <= 2 || !(Math.abs(lst.get((int)0).sre.getVelocity() - lst.get((int)1).sre.getVelocity()) < 0.1) || !(Math.abs(lst.get((int)0).sre.getHeadingRadians() - lst.get((int)1).sre.getHeadingRadians()) < 0.1)) continue;
                this.behaviours.put(robotName, Behavior.STEADYMOVE);
            }
        }
    }

    private void turningMgmt() {
        if (Math.abs(this.getTurnRemaining()) < 2.0) {
            boolean lastTrickyEnemy = this.isLastTrickyEnemy();
            if (lastTrickyEnemy) {
                this.mayChangeDirection = false;
                double bearing = this.robots.get((Object)this.target).get((int)0).sre.getBearingRadians();
                if (this.direction) {
                    this.setTurnRightRadians(bearing + 0.6283185307179586);
                } else {
                    this.setTurnLeftRadians(bearing + 0.6283185307179586);
                }
            } else if (this.rnd.nextBoolean()) {
                this.setTurnLeft(50.0);
            } else {
                this.setTurnRight(50.0);
            }
            if (!this.mayChangeDirection) {
                this.setMaxVelocity(8.0);
                if (!lastTrickyEnemy) {
                    this.mayChangeDirection = true;
                }
            }
        }
    }

    private boolean isLastTrickyEnemy() {
        return this.getOthers() == 1 && this.target != null && this.robots.get(this.target) != null && this.robots.get(this.target).size() > 0;
    }

    private void movingMgmt() {
        double heading = this.getHeading();
        double x = this.getX();
        double y = this.getY();
        if (this.isLastTrickyEnemy()) {
            this.mayChangeDirection = false;
        }
        this.turnBackFromSide(heading, x, y);
        if (Math.abs(this.getDistanceRemaining()) < 10.0) {
            if (this.mayChangeDirection) {
                this.direction = this.rnd.nextBoolean();
            }
            if (this.direction) {
                this.setAhead(100.0);
            } else {
                this.setBack(100.0);
            }
            this.setMaxVelocity(this.rnd.nextInt(5) + 4);
        }
    }

    private void turnBackFromSide(double heading, double x, double y) {
        if (x < 50.0 || x > this.maxX - 50.0 || y < 50.0 || y > this.maxY - 50.0) {
            double aimHeading = -1.0;
            if (x < 50.0) {
                aimHeading = this.direction ? 90 : 270;
            } else if (x > this.maxX - 50.0) {
                aimHeading = this.direction ? 270 : 90;
            }
            if (y < 50.0) {
                aimHeading = this.direction ? 0 : 180;
            } else if (y > this.maxY - 50.0) {
                aimHeading = this.direction ? 180 : 0;
            }
            if (aimHeading != -1.0) {
                double delta = heading - aimHeading;
                while (delta > 180.0) {
                    delta -= 360.0;
                }
                while (delta < -180.0) {
                    delta += 360.0;
                }
                this.setTurnLeft(delta);
                this.mayChangeDirection = false;
                double velocity = this.getVelocity();
                if (Math.abs(velocity) > 5.0) {
                    this.setMaxVelocity(velocity * 2.0 / 3.0);
                }
            }
        }
    }

    private void aimingMgmt() {
        if (this.target == null) {
            return;
        }
        double x = this.getX();
        double y = this.getY();
        Behavior behaviour = this.behaviours.get(this.target);
        if (behaviour == Behavior.STAYS || behaviour == null) {
            this.aimToStayer(x, y);
        } else if (behaviour == Behavior.STEADYMOVE) {
            this.aimToSteadyMover(x, y);
        } else {
            this.target = null;
        }
    }

    private void aimToSteadyMover(double x, double y) {
        List<ScannedRobotEventHolder> lst = this.robots.get(this.target);
        if (lst == null || lst.size() == 0) {
            this.target = null;
            return;
        }
        ScannedRobotEventHolder sreh = lst.get(0);
        double velocity = sreh.sre.getVelocity();
        double heading = sreh.sre.getHeadingRadians();
        double bulletSpeed = Rules.getBulletSpeed((double)this.firePower);
        double targetX = sreh.x;
        double targetY = sreh.y;
        double vx = velocity * Math.cos(1.5707963267948966 - heading);
        double vy = velocity * Math.sin(1.5707963267948966 - heading);
        double time = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double d = 0.0;
        double dDiff = 0.0;
        int iterations = 10;
        do {
            double x1;
            if ((x1 = time * vx + targetX) < 0.0) {
                x1 = 0.0;
            } else if (x1 > this.maxX) {
                x1 = this.maxX;
            }
            dx = x1 - x;
            double y1 = time * vy + targetY;
            if (y1 < 0.0) {
                y1 = 0.0;
            } else if (y1 > this.maxY) {
                y1 = this.maxY;
            }
            dy = y1 - y;
            double newD = Math.sqrt(dx * dx + dy * dy);
            time = newD / bulletSpeed;
            dDiff = newD - d;
            d = newD;
        } while (Math.abs(dDiff) > 0.1 && iterations-- > 0);
        double alpha = Math.asin(Math.abs(dx) / d);
        if (dx < 0.0 && dy < 0.0) {
            alpha += Math.PI;
        } else if (dx < 0.0 && dy >= 0.0) {
            alpha *= -1.0;
        } else if (dx >= 0.0 && dy < 0.0) {
            alpha = Math.PI - alpha;
        } else if (dx >= 0.0) {
            // empty if block
        }
        double delta = alpha - this.getGunHeadingRadians();
        while (delta > Math.PI) {
            delta -= Math.PI * 2;
        }
        while (delta < -Math.PI) {
            delta += Math.PI * 2;
        }
        this.setTurnGunRightRadians(delta);
    }

    private void aimToStayer(double x, double y) {
        List<ScannedRobotEventHolder> lst = this.robots.get(this.target);
        if (lst != null && lst.size() > 0) {
            ScannedRobotEventHolder sreh = lst.get(0);
            double targetX = sreh.x;
            double targetY = sreh.y;
            double dx = targetX - x;
            double dy = targetY - y;
            double d = Math.sqrt(dx * dx + dy * dy);
            double alpha = Math.asin(Math.abs(dx) / d);
            if (dx < 0.0 && dy < 0.0) {
                alpha += Math.PI;
            } else if (dx < 0.0 && dy >= 0.0) {
                alpha *= -1.0;
            } else if (dx >= 0.0 && dy < 0.0) {
                alpha = Math.PI - alpha;
            } else if (dx >= 0.0) {
                // empty if block
            }
            double delta = alpha - this.getGunHeadingRadians();
            while (delta > Math.PI) {
                delta -= Math.PI * 2;
            }
            while (delta < -Math.PI) {
                delta += Math.PI * 2;
            }
            this.setTurnGunRightRadians(delta);
        } else {
            this.target = null;
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.addScannedRobotEvent(scannedRobotEvent);
        if (this.radarStrategy == RadarStrategy.TRACK && this.target == scannedRobotEvent.getName()) {
            this.radarScanMid = scannedRobotEvent.getBearingRadians() + this.getHeadingRadians();
            this.notScanned = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScannedRobotEvent(ScannedRobotEvent sre) {
        Map<String, List<ScannedRobotEventHolder>> map = this.robots;
        synchronized (map) {
            List<ScannedRobotEventHolder> lst = this.robots.get(sre.getName());
            if (lst == null) {
                lst = new ArrayList<ScannedRobotEventHolder>();
                this.robots.put(sre.getName(), lst);
            }
            ScannedRobotEventHolder sreh = new ScannedRobotEventHolder();
            sreh.sre = sre;
            sreh.ownX = this.getX();
            sreh.ownY = this.getY();
            double distance = sre.getDistance();
            double bearing = sre.getBearingRadians() + this.getHeadingRadians();
            sreh.x = this.getX() + distance * Math.sin(bearing);
            sreh.y = this.getY() + distance * Math.cos(bearing);
            sreh.ownHeadingInRad = this.getHeadingRadians();
            lst.add(0, sreh);
            if (lst.size() > 10) {
                lst.remove(10);
            }
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.direction = !this.direction;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.direction = !this.direction;
    }

    public void debugPosition(String msg) {
        System.out.println(msg);
        double x = this.getX();
        double y = this.getY();
        double heading = this.getHeading();
        System.out.println("x: " + x);
        System.out.println("y: " + y);
        System.out.println("h: " + heading);
        System.out.println("d: " + (this.direction ? "ahead" : "back"));
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.robots.remove(event.getName());
        this.behaviours.remove(event.getName());
    }

    public void onBulletHit(BulletHitEvent event) {
        double fp = this.firePower + 0.5;
        if (fp > 3.0) {
            fp = 3.0;
        }
        this.firePower = fp;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        double fp = this.firePower - 0.4;
        if (fp < 0.5) {
            fp = 0.5;
        }
        this.firePower = fp;
    }

    public void onWin(WinEvent event) {
        this.running = false;
    }
}

