/*
 * Decompiled with CFR 0.152.
 */
package rdt199.gun;

import rdt199.Manager;
import rdt199.gun.GunMode;
import rdt199.gun.ShootingLocation;
import rdt199.tracking.BulletTracker;
import rdt199.util.BotFuncs;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;
import rdt199.util.Storage;
import robocode.Bullet;

public class GunManager
extends Manager {
    public GunManager(int maxmodes) {
        super(maxmodes);
        this.m_Current = null;
    }

    public void update() {
        Location Loc = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        RobotLog Target = BotFuncs.getTarget();
        if (Target == null) {
            return;
        }
        RobotSnapshot Snap = Target.get(0);
        if (Snap == null) {
            return;
        }
        double dDistance = BotFuncs.getDistanceBetween(Snap.m_Location, Loc);
        double dFirepower = BotFuncs.getFirepower(dDistance);
        double dBestScore = -1.0;
        int iCount = 0;
        while (iCount < this.m_Modes.size()) {
            GunMode Mode2 = (GunMode)this.m_Modes.get(iCount);
            Mode2.calcPredictedLocation(Loc, dFirepower);
            Mode2.fireVirtualBullet(Loc);
            if (Mode2.getScore() > dBestScore) {
                dBestScore = Mode2.getScore();
                this.m_Current = Mode2;
            }
            ++iCount;
        }
        if (this.m_Current == null) {
            return;
        }
        ShootingLocation PredictedLoc = ((GunMode)this.m_Current).getPredictedLocation();
        if (PredictedLoc != null) {
            this.fireActualBullet(PredictedLoc, (GunMode)this.m_Current);
        }
    }

    public Storage getModes() {
        return this.m_Modes;
    }

    protected void fireActualBullet(ShootingLocation loc, GunMode mode) {
        if (loc == null) {
            return;
        }
        this.track(loc);
        if (!this.readyToFire(loc)) {
            return;
        }
        if (!BotFuncs.isInBattlefield(loc)) {
            return;
        }
        Bullet bullet = BotFuncs.m_AdvancedRobot.setFireBullet(loc.dFirepower);
        if (bullet == null) {
            return;
        }
        BulletTracker bt = new BulletTracker(bullet, BotFuncs.getTarget().getName(), mode);
    }

    protected boolean readyToFire(ShootingLocation loc) {
        if (loc.dFirepower < 0.0) {
            return false;
        }
        if (BotFuncs.m_AdvancedRobot.getGunHeat() != 0.0) {
            return false;
        }
        return !(BotFuncs.m_AdvancedRobot.getGunTurnRemaining() >= 2.0);
    }

    protected void track(Location loc) {
        Location Loc = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dTheta = BotFuncs.getAbsBearing(loc, Loc);
        dTheta = Math.toDegrees(dTheta);
        this.setAbsoluteGun(dTheta);
    }

    protected void setAbsoluteGun(double angle) {
        double dAngle = BotFuncs.normaliseAbsDegrees(angle);
        if (dAngle < BotFuncs.m_AdvancedRobot.getGunHeading()) {
            if (BotFuncs.m_AdvancedRobot.getGunHeading() - dAngle > 180.0) {
                BotFuncs.m_AdvancedRobot.setTurnGunRight(360.0 - (BotFuncs.m_AdvancedRobot.getGunHeading() - dAngle));
            } else {
                BotFuncs.m_AdvancedRobot.setTurnGunLeft(BotFuncs.m_AdvancedRobot.getGunHeading() - dAngle);
            }
        } else if (dAngle - BotFuncs.m_AdvancedRobot.getGunHeading() > 180.0) {
            BotFuncs.m_AdvancedRobot.setTurnGunLeft(360.0 - (dAngle - BotFuncs.m_AdvancedRobot.getGunHeading()));
        } else {
            BotFuncs.m_AdvancedRobot.setTurnGunRight(dAngle - BotFuncs.m_AdvancedRobot.getGunHeading());
        }
    }
}

