package kvk.Movement;
import kvk.ExtendedRobot;
import kvk.Utils.C;
import kvk.Utils.Manager;
import robocode.*;

/**
 *  Classe de gestion des mouvements
 *
 * @author     Ssin.le.Terrible
 * @created    14 janvier 2004
 */
public class MoveManager extends Manager {
	//{{{*** VARIABLES
	private  Manager[]  moveList;                                                  //Liste des types de mouvement
	private  int        currentMove;                                               //Position du mouvement en cours d'utilisation
	//**********************************************************//}}}

	public MoveManager(ExtendedRobot er) {
		super(er);
		moveList = new Manager[C.MOVE_MODES];
		// Initialisation des modes de mouvement
		moveList[C.MOVE_NIMROD_STYLE] = new MoveNimrodStyle(myBot);                   //Mouvement de Nimrod 0.55
		moveList[C.MOVE_RANDOM_OvO_STYLE] = new MoveRandomOvOStyle(myBot);            //Mouvement alatoire pour duel
		moveList[C.MOVE_TO_CENTER] = new MoveToCenter(myBot);
		// Initialisation du mouvement courant
		currentMove = C.MOVE_NIMROD_STYLE;
	}

	/**
	 *  Action  raliser chaque tour
	 */
	public void action() {
		//Test si mouvements interdits
		if (!myBot.canMove) {
			return;
		}

		// Choix du type de mouvement
		if (myBot.getTarget() == null) {
			currentMove = C.MOVE_TO_CENTER;
		}
		else if (myBot.isOvO()) {
			currentMove = C.MOVE_RANDOM_OvO_STYLE;
		}
		else {
			currentMove = C.MOVE_NIMROD_STYLE;
		}
		// Excution du mouvement
		moveList[currentMove].action();
	}

	/**
	 *  Rinitialisation  effectuer chaque round
	 */
	public void reinitialise() {
		// Initialisation du mouvement courant
		currentMove = C.MOVE_NIMROD_STYLE;
		moveList[currentMove].reinitialise();
	}
}

