package djc.gun;

import djc.*;
import djc.util.*;

import java.awt.geom.*;
import java.util.*;

import robocode.*;

/**
 * FunkyChicken Gun
 * 
 * Modified version of kawigi.nano.FunkyChicken
 */
public class FunkyChickenGun extends BaseGun
{
	public FunkyChickenGun(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "FUNKYCHICKENGUN";
		gunID = DynaBotConstants.FUNKYCHICKENGUN;
	}
	
	public double calcGunTurnRadians(Enemy e) {
		double absbearing = e.absBearing;
		
		//rounding to be more accurate in projection!
		//pattern.insert(0, (char)(Math.round(Math.sin(e.getHeadingRadians() - (absbearing = absbearing + myrobot.getHeadingRadians()))*e.getVelocity())));
		int index=0, searchlength = 30;
		StringBuffer pattern = (StringBuffer)myrobot.theEnemyManager.funkyChickenPatterns.get(e.name);
		//lol, if I ever make a haiku pattern-matcher, this will be in it:
		while ((index = pattern.toString().indexOf(pattern.substring(0, searchlength--), 1)) < 0);
		
		//searchlength will now become the index of the StringBuffer that I will project back to (back because my pattern 
		//is stored backward).
		double dist = e.lastDistance;
		double power = computeFirePower(dist, e);
		double shotVel = MyUtils.getShotVelocity(power);
		// TODO - fix this up...
		//searchlength =  index - (int)((dist = e.getDistance())/(20-(power = Math.min(3, Math.min(myrobot.getEnergy(), e.getEnergy())/4))*3));
		
		searchlength =  index - (int)(dist/shotVel);
		
		//just add the offset to the bearing instead of making a new variable!
		//The fact that this actually reconstructs future movement (like a normal pattern-matcher does) probably makes this
		//just about the most accurate current nano pattern-matcher (except possibly Kakuru's, since it uses doubles instead of
		//characters).  The nice thing about it is that it correctly projects patterns even if I'm at a different distance than
		//when I collected the pattern.
		do
		{
			absbearing += Math.asin(((byte)pattern.charAt(index--))/dist);
		}
		while (index >= Math.max(0, searchlength));
		return absbearing;
	}

}
