package djc.gun;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;     // for Point2D's

import robocode.*;
import robocode.util.*;

/**
 * MyClass - a class by (your name here)
 */
public class LinearGun extends BaseGun
{
	public LinearGun(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "LINEARGUN";
		gunID = DynaBotConstants.LINEARGUN;
	}
	
	/**
	 *  Iterate over predictPosition
	 */
	public double calcGunTurnRadians(Enemy e) {
		double shotPower = computeFirePower(e.lastDistance, e);
		double shotVelocity = MyUtils.getShotVelocity(shotPower);
		double estDist = e.lastDistance;
		double estFlightTime = estDist / shotVelocity;
		Point2D.Double endPoint = new Point2D.Double(e.location.getX(), e.location.getY());
		double errorMargin = 4;
		
		for(int i=0;i<10;i++) {
			endPoint = predictPosition(e, estFlightTime);
			if(Math.abs(estDist - myrobot.location.distance(endPoint)) < errorMargin) break;
			estDist = myrobot.location.distance(endPoint);
			estFlightTime = estDist / shotVelocity;
		}
	
		return MyUtils.absoluteBearing(myrobot.location, endPoint);
	}
	
    /**
     * predicts the position for a given time
     */
    public Point2D.Double predictPosition(Enemy e, double futureTime) {
		double dist = (futureTime + myrobot.getTime() - e.lastTimePosition) * e.linVelocity;
		double x = dist * Math.sin(e.heading);
		double y = dist * Math.cos(e.heading);
        Point2D.Double retval = new Point2D.Double(e.location.x + x, e.location.y + y);
		myrobot.theBattleManager.translateInsideField(retval, 1);
		return retval;
    }	
}
