/* This is the sensors module for the StiX Modular Robot System
 * This class handles all gun management for the robot, and it easily
 * modified for any gun system or virtual gun syste, you want.
 */
package amk.ShizzleStiX;
import robocode.*;
import java.awt.geom.Point2D;

class Sensory extends Module
{
	Battlefield field = new Battlefield();
	
	/* The standard constructor */
	public Sensory(ShizzleStiX bot) {
		this.bot = bot;
		bot.setAdjustRadarForGunTurn(true);
		bot.setAdjustRadarForRobotTurn(true);
	}
	
	public void run() {
		bot.setTurnRadarLeft(3600);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		FieldUnit thisUnit = new FieldUnit();
		thisUnit.setCreationTime(bot.getTime());
		
		double myX = bot.getX();
		double myY = bot.getY();
		
		thisUnit.setName(e.getName());
		thisUnit.setAbsoluteBearing(e.getHeadingRadians() + e.getBearingRadians());
		thisUnit.setBearing(e.getBearing());
		thisUnit.setBearingRadians(e.getBearingRadians());
		thisUnit.setHeadingRadians(e.getHeadingRadians());
		thisUnit.setHeading(e.getHeading());
		thisUnit.setSpeed(e.getVelocity());
		thisUnit.setDistance(e.getDistance());
		thisUnit.setEnergy(e.getEnergy());
		thisUnit.setPosition(new Point2D.Double(myX + thisUnit.getDistance() * Math.sin(thisUnit.getBearing()), myY + thisUnit.getDistance() * Math.cos(thisUnit.getBearing())));
		
		if(bot.isTeammate(e.getName())) { field.addTeammate(thisUnit); }
		else { field.addEnemy(thisUnit); }
		
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		String name = e.getName();
		if(bot.isTeammate(name)) {
			field.deleteTeammate(name);
		} else {
			field.deleteEnemy(name);
		}
		bot.Weapons.target = null;
	}
	
}
