package gh.ghutils;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

/**
 * GHUtils
 *
 * This class contains several common utility routines.
 * Credit: Inspired by Dookious by Voidious
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */
public class GHUtils {
	public static final double BOTWIDTH		 = 36;
	public static final double HALFBOTWIDTH	 = BOTWIDTH / 2;
	public static final double WALLMARGIN	 = HALFBOTWIDTH;
	public static final double BLINDMANSTICK = 130;	// my wallsmoothing distance

	// movement
	public static final int	MBINS			= 37;
	public static final int	MMIDBIN			= MBINS / 2;
	public static final int	MVELSEG			= 3;	// 0..2 - 2..6 - 6..8
	public static final int	MWALLSEG		= 5;	// none, heading for wall close, heading for wall far, retreating from wall close, retreating from wall far
	public static final int	MACCSEG			= 5;	// accell, decell, constant < 6, constant < 16, constant > 16
	public static final int	MDL14SEG		= 4;	// 14-tick distance 0-28 28-56 56-84 84-112 (max in 14 ticks)

	// gun
	public static final int GBINS			= 73;
	public static final int GMIDBIN			= GBINS / 2;
	public static final int	GACCSEG			= 6;	// accell, decell, time <6, <16, <36, >=36
//	static final int	DISTSEG			= 4;	// 0-300-450-600-9999
	public static final int	GVELSEG			= 3;	// 0 - 2.5 - 5.5 - 8
	public static final int	GWALLSEG		= 6;	// none, heading for wall close, heading for wall far, retreating from wall close, retreating from wall far, corner
	public static final int	GDL14SEG		= 4;	// 14-tick distance 0-28 28-56 56-84 84-112 (max in 14 ticks)

	public static double battleFieldWidth = 800;
	public static double battleFieldHeight = 600;
	public static RoundRectangle2D.Double moveField;
	public static Rectangle2D.Double fireField;
	public static double gunCoolingRate = 0.1;
	public static double roundNumber;

	// Utility routines
	
	// doProjectPos: Calculate position out of startposition, heading and distance
	public static Point2D.Double doProjectPos( Point2D.Double startpos, double head, double dist){	
		return new Point2D.Double( startpos.x + (dist * Math.sin( head)), startpos.y + (dist * Math.cos( head)));			
	}

	// doGetAngle: Calculate angle out of two positions
	public static double doGetAngle( Point2D.Double startPos, Point2D.Double endPos) {
		return ( Math.atan2( endPos.x - startPos.x, endPos.y - startPos.y));
	}

	// getEstNextSpeed: Get estimation of next robot velocity
	public static double getEstNextSpeed( double curvel, double prevvel) {
		double estvel = Math.max(-2, Math.min((curvel - prevvel), 2));
		estvel = Math.max(-Rules.MAX_VELOCITY, Math.min((curvel + estvel), Rules.MAX_VELOCITY));
		return estvel;
	}

	// setBackAsFront: Take the shortest turn to the desired angle
	public static void setBackAsFront( AdvancedRobot robot, double goAngle, int direction) {
		double angle = Utils.normalRelativeAngle( goAngle - TickState.getHeading(0));
		double myAngle = Math.atan( Math.tan( angle));
		robot.setTurnRightRadians( myAngle);
		if (direction == 0)
			robot.setAhead( 0);		// stop-position
		else
			robot.setAhead( angle == myAngle ? BLINDMANSTICK : -BLINDMANSTICK);
	}

	// wallSmoothing: A WaveSurfer does not avoid the walls, but moves smoothly along them
	public static double wallSmoothing( Point2D.Double startPoint, double angle) {
		double di;

		for (di = 0; di < Math.PI; di += Math.PI/72) {
			if (moveField.contains( doProjectPos( startPoint, angle+di, BLINDMANSTICK))) {
				break;
			}
			if (moveField.contains( doProjectPos( startPoint, angle-di, BLINDMANSTICK))) {
				di = -di;
				break;
			}
		}
		return ( angle + di);
	}

	// set the battlefield (slightly different) for movement and gunnery
	public static void setBattleFieldSize (double w, double h) {
		battleFieldWidth = w;
		battleFieldHeight = h;
		moveField = new RoundRectangle2D.Double( WALLMARGIN, WALLMARGIN,
						battleFieldWidth - 2 * WALLMARGIN,
						battleFieldHeight - 2 * WALLMARGIN, 50, 50);
		fireField = new Rectangle2D.Double( WALLMARGIN, WALLMARGIN,
						battleFieldWidth - 2 * WALLMARGIN,
						battleFieldHeight - 2 * WALLMARGIN);
	}
	
	// remember guncoolingrate
	public static void setGunCoolingRate (double r) {
		gunCoolingRate = r;
	}

	// remember roundnumber
	public static void setRoundNumber( int round) {
		roundNumber = round + 1;
	}

}
