package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/*
 *	TrackingRadar - controls the radar to stay facing the enemy
 */
public class TrackingRadar extends RadarControl implements java.io.Serializable
{
	private TargetSelector targetter;
	public TrackingRadar(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot);
		this.targetter = targetter;
	}
	
	public void onEvent(Event e)
	{
	}
	
	public void setAction()
	{
		EnemyState target = ((TargetChooser)targetter.getSelectedPart()).chooseTarget();
		if (target == null)
			robot.setTurnRadarRight(40);
		else if (target.getTimeElapsed(robot.getTime())>20 || target.getTimeElapsed(robot.getTime()) < 0)
			robot.setTurnRadarRight(40);
		else
		{
			double angle = target.getAbsoluteBearing(robot.getX(), robot.getY())-robot.getRadarHeadingRadians();
			angle = ((angle+Math.PI)%(Math.PI*2)-Math.PI*2)%(Math.PI*2)+Math.PI;
			robot.setTurnRadarRightRadians(angle);
		}
	}
}
