package wee;
import robocode.*;
import robocode.util.*;
import java.awt.Color;

/**
 * wee.Gem (1.8.4) - a robot by Rod Hyde.
 *
 * This robot is open source. Feel free to copy the source as long as you don't
 * pass it off as your own, as long as you don't sell it and as long as you give
 * credit where it is due. Heck, I wish I didn't have to borrow other people's
 * guns but I don't have a mathematical brain.
 *
 * Changes from 1.8.3 (the final minibot challenge showdown release)
 * - removed colours
 * - counter-intuitive tweak to gun power
 * 
 * Changes from 1.8.2 (the "taking a break from writing Robocode3D" release)
 * - removed normalize() method in favour of Utils.normalRelativeAngle()
 * - larger movements until a wall has been reached. I liked Infinity's idea of
 *   heading for the corner, but I wanted to make sure that Gem reached a wall
 *   even after colliding with another robot.
 *
 * Changes from 1.7.3
 * - reintroduced range limit to firing
 * - removed rolling average velocity in aim
 * - tweaked gun power
 * - changed radar a little
 *
 * Changes from 1.6.1
 * - aim now incorporates weighted rolling average velocity
 * - trimmed some fat from code
 * - tweaked bullet power, radar and movement
 *
 * Changes from 1.5.0
 * - tweaked bullet power and movement
 *
 * Changes from 1.4.3
 * - changed movement to avoid linear and circle leading
 * - removed direction changes when hit by bullets
 * - finally bit the bullet and half-inched Mike's gun (or the Pinball variation
 *   on that theme)
 *
 * Changes from 1.3.0
 * - firing now based on range and energy
 * - tweaked radar to reduce code size
 * - made reverse direction conditional on bullet power
 * - slightly larger turning circle
 *
 * Changes from 1.2.0
 * - added colour (hey, it was either that or a gloat routine)
 * - changed radar scanning to focus on closest scanned bot with occasional
 *   partial sweep
 * - added range limit to firing
 * - replaced my own bulky lead fire code with slimline code from Jan Schrader's
 *   Pinball, which in turn appears to have come from bots by Stuart Holliday
 *   and/or Mike Dorgan
 * - minor tweaks to movemement, but still uses same basic circling: reverses
 *   direction immediately after being hit by a bullet but doesn't change
 *   angular velocity until it has stopped turning
 * 
 * Credits
 * - the gun comes from PinBall by Jan Schrader, but I believe it is originally
 *   from Infinity by Mike Dorgan
 */

final public class Gem extends AdvancedRobot
{
	static double		radarTurn = 1;
	static double		lastHeading;
	static boolean	scanned;
	static double		direction;

	final public void run() {
		direction = 10000;
//		setColors(Color.red, Color.red, Color.red);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do {
			scanned = false;
			if (0 == getVelocity()) {
				setAhead(direction = -direction);
				setTurnRightRadians(Math.PI/2);
			}
			setTurnRadarRightRadians(radarTurn);
			execute();
		} while (true);
	}
	
	/**
	 * Calls to onScannedRobot are sorted by closest distance first, so we just
	 * pick the closest one each time and ignore the others. We also don't
	 * bother if the target is further than a given distance as this
	 * significantly increases both bullet damage and survival.
	 */
	final public void onScannedRobot(ScannedRobotEvent e) {
		if (scanned || (e.getDistance() > 450 && getOthers() > 2)) return;
		scanned = true;
		double bearing = getHeadingRadians() + e.getBearingRadians();
		radarTurn = Utils.normalRelativeAngle(bearing - getRadarHeadingRadians()) * 1000;
		if (getGunHeat() == getGunTurnRemaining()) {
			setFire(4 * getOthers() * getEnergy() / e.getDistance());
		}
		setTurnGunRightRadians(
				Utils.normalRelativeAngle(
					bearing
						- getGunHeadingRadians()
						+ Math.sin(
							lastHeading
								- bearing
								+ (bearing =
									(e.getDistance() / 36)
										* (-lastHeading + (lastHeading = e.getHeadingRadians()))))
							* Math.asin(e.getVelocity() / (4 * (4 + Math.abs(bearing))))));
	}
	
	final public void onHitWall(HitWallEvent e) {
		direction = 160 * Math.abs(direction)/direction;
	}
}
