package maribo.melee;
import robocode.*;
import robocode.util.*;
import java.awt.Color;

/**
 * BMV - a robot by Alexander MacKenzie
 * 	Version 0.1: 	Codesize: 248 bytes with colours
 * 
 */
public class BMV extends AdvancedRobot {
	public int dir = 1;
	public double moveDist, dist;
	public void run() {
		setColors(Color.green,Color.black,Color.green,Color.black,Color.green);
		setAdjustGunForRobotTurn(true);
	
		while(true) {
			if (getDistanceRemaining() == 0) { setAhead(moveDist = (((Math.random() * 200) + 75) * (dir *= -1))); }
			if (getRadarTurnRemaining() == 0) { setTurnRadarRight(Double.POSITIVE_INFINITY); dist = 1200; }
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		int bulletPower = (e.getDistance() > 127) ? 2 : 3;
		
		if (e.getDistance() < dist+15) {
			dist = e.getDistance();

    		double headOnBearing;
			double turnAmount = Utils.normalRelativeAngle(((headOnBearing = getHeadingRadians() + e.getBearingRadians())
					 + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower)
					 * Math.sin(e.getHeadingRadians() - headOnBearing)))
					 - getGunHeadingRadians());
    		setTurnGunRightRadians(turnAmount);
			setTurnRadarRightRadians(2.1*Utils.normalRelativeAngle(headOnBearing - getRadarHeadingRadians()));
			setFire(bulletPower);
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		setTurnRightRadians(e.getBearingRadians() + Math.PI/2);
	}
	
	public void onHitWall(HitWallEvent e) {
		setAhead(moveDist * -1);
	}	
}
								