/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith;

import java.awt.Color;
import java.awt.Graphics2D;
import rdt.AgentSmith.EnergyManagement;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionMovementMode;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionState;
import rdt.AgentSmith.Movement.StationaryMovementMode;
import rdt.AgentSmith.Setup;
import rdt.AgentSmith.SetupIO;
import rdt.BulletShadow.BulletShadowTracker;
import rdt.Debug.Debug;
import rdt.Guns.CloseUpGunMode;
import rdt.Guns.GunVirtualGunArrayMode;
import rdt.Radar.RadarGetATargetMode;
import rdt.Radar.RadarOneVOneMode;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataModification;
import rdt.RobotData.RobotDataSnapshot;
import rdt.SubsystemManager;
import rdt.Targeting.Targeting;
import rdt.Utils.MathUtils;
import rdt.Waves.WaveManager;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.annotation.SafeStatic;

public class AgentSmith
extends AdvancedRobot {
    @SafeStatic
    private static AgentSmith _instance = null;
    private static SubsystemManager _radar = null;
    private static SubsystemManager _guns = null;
    private static SubsystemManager _movement = null;
    private static RobotData _ourData = null;
    public static EnergyManagement Energy = null;
    public static BulletShadowTracker _bulletShadowTracker = null;
    private double _botSizeMax = 0.0;
    private double _botSizeMaxHalf = 0.0;
    private double _botSizeMin = 0.0;
    private double _botSizeMinHalf = 0.0;
    private DangerPredictionState _predictedPosition;
    private static long _totalTicks = 0L;
    private boolean _initialised = false;

    public static AgentSmith Instance() {
        return _instance;
    }

    public void run() {
        this.Initialise();
        while (true) {
            this.UpdateOurData();
            Targeting.UpdateTargeting();
            if (Energy != null) {
                Energy.Update();
            }
            _radar.Update();
            if (Setup.Instance.EnableBulletShadow) {
                _bulletShadowTracker.Update();
            }
            if (Setup.Instance.EnableMovement) {
                _movement.Update();
            }
            if (Setup.Instance.EnableGun) {
                _guns.Update();
            }
            ++_totalTicks;
            this.execute();
        }
    }

    private void Initialise() {
        this.Shutdown();
        this._initialised = true;
        _instance = this;
        double width = this.getWidth();
        double height = this.getHeight();
        this._botSizeMax = Math.sqrt(width * width + height * height);
        this._botSizeMaxHalf = this._botSizeMax / 2.0;
        this._botSizeMin = Math.min(width, height);
        this._botSizeMinHalf = this._botSizeMin / 2.0;
        if (Setup.Instance == null) {
            SetupIO.ReadSetup();
        }
        this.setColors(Color.white, Color.black, Color.white);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setMaxVelocity(8.0);
        Debug.InitDebug();
        Debug.StartOfRound();
        Targeting.InitTargeting();
        if (_ourData == null) {
            _ourData = new RobotData("AgentSmith", 5);
        }
        RobotDataModification.Reset(_ourData);
        if (_radar == null) {
            _radar = new SubsystemManager();
            _radar.Initialise("Radar");
            _radar.AddMode(new RadarGetATargetMode());
            _radar.AddMode(new RadarOneVOneMode());
        }
        _radar.OnRoundStart();
        WaveManager ourWaveManager = null;
        if (_guns == null) {
            GunVirtualGunArrayMode vgArrayMode = new GunVirtualGunArrayMode();
            _guns = new SubsystemManager();
            _guns.Initialise("Guns");
            _guns.AddMode(vgArrayMode);
            _guns.AddMode(new CloseUpGunMode());
            ourWaveManager = vgArrayMode.GetWaveManager();
        }
        _guns.OnRoundStart();
        WaveManager enemyWaveManager = null;
        if (_movement == null) {
            DangerPredictionMovementMode dpMovementMode = new DangerPredictionMovementMode();
            _movement = new SubsystemManager();
            _movement.Initialise("Movement");
            _movement.AddMode(dpMovementMode);
            _movement.AddMode(new StationaryMovementMode());
            enemyWaveManager = dpMovementMode.GetWaveManager();
        }
        _movement.OnRoundStart();
        if (Energy == null) {
            Energy = new EnergyManagement();
        }
        Energy.StartOfRound();
        if (_bulletShadowTracker == null) {
            _bulletShadowTracker = new BulletShadowTracker(ourWaveManager, enemyWaveManager);
        }
        _bulletShadowTracker.OnRoundStart();
    }

    private void Shutdown() {
        Debug.EndOfRound();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.UpdateOurData();
        Targeting.OnScannedRobot(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (Targeting.GetCurrentTarget() != null) {
            Targeting.GetCurrentTarget().Dead = true;
        }
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this.Shutdown();
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        System.out.println("******************** Skipped Turn Detected! *****************");
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.UpdateOurData();
        Targeting.OnHitByBulletEvent(event);
        _movement.OnHitByBulletEvent(event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.UpdateOurData();
        Targeting.OnBulletHitEvent(event);
        _guns.OnBulletHitEvent(event);
    }

    public void onHitWall(HitWallEvent event) {
        this.UpdateOurData();
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.UpdateOurData();
        _guns.OnBulletMissedEvent(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.UpdateOurData();
        _guns.OnBulletHitBulletEvent(event);
        _movement.OnBulletHitBulletEvent(event);
    }

    public void onPaint(Graphics2D gfx) {
        if (Setup.Instance.EnableMovement && Setup.Instance.EnableMovementDebug) {
            _movement.DebugDraw(gfx);
        }
        _radar.DebugDraw(gfx);
        if (Setup.Instance.EnableGun && Setup.Instance.EnableGunDebug) {
            _guns.DebugDraw(gfx);
        }
        Targeting.DebugDraw(gfx);
        Energy.DebugDraw(gfx);
        if (Setup.Instance.EnableBulletShadowDebug) {
            _bulletShadowTracker.DebugDraw(gfx);
        }
    }

    public RobotDataSnapshot GetLatestSnapshot() {
        return this.GetSnapshot(0);
    }

    public RobotDataSnapshot GetSnapshot(int turnsAgo) {
        if (turnsAgo >= AgentSmith._ourData.NumSnapshots) {
            return null;
        }
        return AgentSmith._ourData.Snapshots.get(turnsAgo);
    }

    public RobotData GetRobotData() {
        return _ourData;
    }

    public double GetBotSizeMax() {
        return this._botSizeMax;
    }

    public double GetBotSizeMaxHalf() {
        return this._botSizeMaxHalf;
    }

    public double GetBotSizeMin() {
        return this._botSizeMin;
    }

    public double GetBotSizeMinHalf() {
        return this._botSizeMinHalf;
    }

    private void UpdateOurData() {
        double targetX = 0.0;
        double targetY = 0.0;
        double absAngleFromTargetToUs = 0.0;
        RobotData targetData = Targeting.GetCurrentTarget();
        if (targetData != null && targetData.Valid && targetData.NumSnapshots > 0) {
            RobotDataSnapshot targetSnapshot = targetData.Snapshots.get(0);
            targetX = targetSnapshot.LocationX;
            targetY = targetSnapshot.LocationY;
            absAngleFromTargetToUs = MathUtils.GetAngle(targetX, targetY, this.getX(), this.getY());
        }
        RobotDataModification.UpdateSnapshot(_ourData, this.getX(), this.getY(), this.getHeadingRadians(), this.getVelocity(), this.getEnergy(), targetX, targetY, absAngleFromTargetToUs);
    }

    public void SetPredictedPositionNextTick(DangerPredictionState state) {
        this._predictedPosition = state;
    }

    public DangerPredictionState GetPredictedPosition() {
        return this._predictedPosition;
    }

    public long GetTotalTicks() {
        return _totalTicks;
    }
}

