/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement;

import java.awt.Color;
import rdt.AgentSmith.AgentSmith;
import rdt.AgentSmith.Movement.EnemyWaveTargetInterface;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Targeting.Targeting;
import rdt.VirtualGuns.VirtualGuns;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;
import rdt.Waves.WaveManager;

public class EnemyWaveManager
extends WaveManager {
    private VirtualGuns _virtualGuns = null;

    public EnemyWaveManager() {
        super(new EnemyWaveTargetInterface(), 50, Color.red);
    }

    public void SetVirtualGuns(VirtualGuns guns) {
        this._virtualGuns = guns;
    }

    @Override
    public void Update() {
        double firePower;
        RobotData enemyData = Targeting.GetCurrentTarget();
        RobotDataSnapshot enemySnapshot = null;
        if (enemyData != null && enemyData.Valid) {
            enemySnapshot = enemyData.Snapshots.get(0);
        }
        if (enemySnapshot != null && !enemyData.Dead && (firePower = enemySnapshot.BulletFirepower) > 0.0) {
            VirtualGunsFiringData firingData = this._virtualGuns.GetFiringData(firePower);
            this.AddWave(firingData, WaveData.eWaveType.Real);
        }
        super.Update();
    }

    @Override
    protected boolean CheckWaveShouldBeRemoved(WaveData wave) {
        return wave.AbsTickAngleSnapshotsOutsideBattlefield < AgentSmith.Instance().getTime();
    }
}

