/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns;

import rdt.Utils.RollingAverage;
import robocode.Rules;

public class VirtualGunStats {
    private String _name;
    private int _hitsVirtual;
    private int _missesVirtual;
    private double _energyLostVirtual;
    private double _actualWeight;
    private double _virtualWeight;
    private int _hitsActual;
    private int _missesActual;
    private int _energyLostActual;
    private RollingAverage _virtualRollingAverage = new RollingAverage(50, 1.0);
    private RollingAverage _actualRollingAverage = new RollingAverage(5, 1.0);

    public VirtualGunStats(String name, double actualWeight, double virtualWeight) {
        this._name = name;
        this._actualWeight = actualWeight;
        this._virtualWeight = virtualWeight;
    }

    public String GetName() {
        return this._name;
    }

    public double GetVirtualHitPercent() {
        if (this._missesVirtual <= 0) {
            if (this._hitsVirtual <= 0) {
                return 0.0;
            }
            return 1.0;
        }
        return (double)this._hitsVirtual / (double)(this._hitsVirtual + this._missesVirtual);
    }

    public double GetActualHitPercent() {
        if (this._missesActual <= 0) {
            if (this._hitsActual <= 0) {
                return 0.0;
            }
            return 1.0;
        }
        return (double)this._hitsActual / (double)(this._hitsActual + this._missesActual);
    }

    public void LogHitVirtual(double firepower) {
        ++this._hitsVirtual;
        double damage = Rules.getBulletDamage((double)firepower);
        this._energyLostVirtual += damage;
        this._virtualRollingAverage.AddEntry(this.GetVirtualHitPercent());
    }

    public void LogMissVirtual() {
        ++this._missesVirtual;
        this._virtualRollingAverage.AddEntry(this.GetVirtualHitPercent());
    }

    public void LogHitActual(double firepower) {
        ++this._hitsActual;
        double damage = Rules.getBulletDamage((double)firepower);
        this._energyLostActual = (int)((double)this._energyLostActual + damage);
        this._actualRollingAverage.AddEntry(this.GetActualHitPercent());
    }

    public void LogMissActual() {
        ++this._missesActual;
        this._actualRollingAverage.AddEntry(this.GetActualHitPercent());
    }

    public double GetWeightedHitPercent() {
        double virtualHitPercent = this.GetVirtualHitPercent();
        double actualHitPercent = this.GetActualHitPercent();
        return virtualHitPercent * this._virtualWeight + actualHitPercent * this._actualWeight;
    }

    public double GetRollingHitPercent() {
        double virtualHitPercent = this._virtualRollingAverage.Average();
        double actualHitPercent = this._actualRollingAverage.Average();
        return virtualHitPercent * this._virtualWeight + actualHitPercent * this._actualWeight;
    }

    public String GetDebugText() {
        return String.format("%-15s A: %.2f%% V %.2f%% W %.2f%% R %.2f%%", this._name, this.GetActualHitPercent() * 100.0, this.GetVirtualHitPercent() * 100.0, this.GetWeightedHitPercent() * 100.0, this.GetRollingHitPercent() * 100.0);
    }
}

