/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Movement;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import wcsv.PowerHouse.Movement.predictionData;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

public class MovementPredictor {
    public static final double slowTurn = Math.toRadians(40.0);
    public static final double diveOffset = Math.toRadians(10.0);
    public static final double WALL_DISTANCE = 20.0;
    public static final double CHECK_DISTANCE = 150.0;
    public static final Rectangle2D.Double fieldRect = new Rectangle2D.Double(20.0, 20.0, Utilities.fWidth - 40.0, Utilities.fHeight - 40.0);

    public static double wallCorrectedAngle(double angle, Point2D.Double loc, double orbit) {
        double locWallX = Math.min(loc.getX() - 20.0, Utilities.fWidth - loc.getX() - 20.0);
        double locWallY = Math.min(loc.getY() - 20.0, Utilities.fHeight - loc.getY() - 20.0);
        Point2D.Double dest = Utilities.projectPoint(loc, angle, 150.0);
        double destWallX = Math.min(dest.getX() - 20.0, Utilities.fWidth - dest.getX() - 20.0);
        double destWallY = Math.min(dest.getY() - 20.0, Utilities.fHeight - dest.getY() - 20.0);
        double adj = 0.0;
        int i = 0;
        while (!fieldRect.contains(dest) && i++ < 15) {
            if (destWallX < 0.0 && destWallX < destWallY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adj = Math.abs(locWallX);
            } else if (destWallY < 0.0 && destWallY <= destWallX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adj = Math.abs(locWallY);
            }
            dest = Utilities.projectPoint(loc, angle += orbit * (Math.acos(adj / 150.0) + 0.0025), 150.0);
            destWallX = Math.min(dest.getX() - 20.0, Utilities.fWidth - dest.getX() - 20.0);
            destWallY = Math.min(dest.getY() - 20.0, Utilities.fHeight - dest.getY() - 20.0);
        }
        return angle;
    }

    public static predictionData nextLocation(predictionData data, double wantedHeading, double wantedVelocity) {
        int dir = 0;
        double angleToTurn = Utilities.relativeAngle(wantedHeading - data.heading);
        if (Math.abs(angleToTurn) > 1.5707963267948966) {
            dir = -1;
            angleToTurn = angleToTurn > 0.0 ? (angleToTurn -= Math.PI) : (angleToTurn += Math.PI);
            angleToTurn = Utilities.relativeAngle(angleToTurn);
        } else {
            dir = 1;
        }
        wantedVelocity = Math.abs(angleToTurn) >= slowTurn ? 0.0 : wantedVelocity;
        double tr = Utilities.maxTurnRate(data.velocity);
        if (angleToTurn < 0.0) {
            data.heading -= Math.min(tr, Math.abs(angleToTurn));
        } else if (angleToTurn > 0.0) {
            data.heading += Math.min(tr, Math.abs(angleToTurn));
        }
        data.heading = Utilities.absoluteAngle(data.heading);
        data.velocity = wantedVelocity == 0.0 ? (data.velocity > 0.0 ? Math.max(wantedVelocity, data.velocity - (double)2) : Math.min(wantedVelocity, data.velocity + (double)2)) : (dir == 1 ? (data.velocity < 0.0 ? Math.min(wantedVelocity, data.velocity + (double)2) : Math.min(wantedVelocity, data.velocity + 1.0)) : (data.velocity > 0.0 ? Math.max(-wantedVelocity, data.velocity - (double)2) : Math.max(-wantedVelocity, data.velocity - 1.0)));
        data.location = Utilities.projectPoint(data.location, data.heading, data.velocity);
        return data;
    }

    public static Point2D.Double projectLocation(Wave w, Target me, Target enemy, double orbit, double minDistance, double wantedVelocity) {
        predictionData data = new predictionData(me.location, me.heading, me.velocity);
        Wave w1 = w.cloneWave();
        while (w1.distanceToPoint(data.location) > w.velocity * (double)2) {
            double bearingOffset = 1.5707963267948966 * (Utilities.distance(data.location, w.sourceRobot.location) / minDistance);
            double wantedHeading = Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(w.sourceRobot.location, data.location) + bearingOffset * orbit);
            wantedHeading = MovementPredictor.wallCorrectedAngle(wantedHeading, data.location, orbit);
            data = MovementPredictor.nextLocation(data, wantedHeading, wantedVelocity);
            w1.advance();
        }
        return data.location;
    }
}

