/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.DownstreamComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.layer.AbstractLayer;
import dmonner.xlbp.layer.CopySourceLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.UpstreamLayer;

public abstract class AbstractUpstreamLayer
extends AbstractLayer
implements UpstreamLayer {
    private static final long serialVersionUID = 1L;
    protected DownstreamLayer downstream = null;
    protected int nDownstream = 0;
    protected int myIndexInDownstream = -1;
    protected CopySourceLayer downstreamCopyLayer;

    public AbstractUpstreamLayer(AbstractUpstreamLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public AbstractUpstreamLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void addDownstream(DownstreamComponent downstream) {
        if (this.downstream != null) {
            throw new IllegalStateException("Downstream layer for " + this.name + " already set!");
        }
        this.nDownstream = 1;
        this.downstream = downstream.asDownstreamLayer();
        this.connectDownstream();
        this.myIndexInDownstream = downstream.indexOfUpstream(this);
    }

    @Override
    public void addDownstreamCopyLayer(CopySourceLayer copySource) {
        if (this.downstreamCopyLayer != copySource) {
            if (this.downstreamCopyLayer != null) {
                throw new IllegalStateException("Cannot add " + copySource + " as the downstream copy layer for " + this.name + " since " + this.downstreamCopyLayer + " already fills that role.");
            }
            this.downstreamCopyLayer = copySource;
        }
    }

    @Override
    public UpstreamLayer asUpstreamLayer() {
        return this;
    }

    @Override
    public void build() {
        if (!this.built) {
            this.myIndexInDownstream = this.downstream.indexOfUpstream(this);
            if (this.downstream.size() != this.size()) {
                throw new IllegalStateException("Incompatible sizes between " + this.name + " (" + this.size() + ") and " + this.downstream.getName() + " (" + this.downstream.size() + ").");
            }
            this.built = true;
        }
    }

    protected void connectDownstream() {
        if (!this.downstream.connectedUpstream(this)) {
            this.downstream.addUpstream(this);
        }
    }

    @Override
    public boolean connectedDownstream(DownstreamComponent downstream) {
        return this.downstream == downstream;
    }

    @Override
    public abstract AbstractUpstreamLayer copy(NetworkCopier var1);

    @Override
    public AbstractUpstreamLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof AbstractUpstreamLayer) {
            AbstractUpstreamLayer that = (AbstractUpstreamLayer)comp;
            this.downstream = copier.getCopyIfExists(that.downstream);
            this.nDownstream = that.nDownstream;
            this.myIndexInDownstream = that.myIndexInDownstream;
        }
    }

    protected void disconnectDownstream(DownstreamComponent downstream) {
        int index;
        if (downstream != null && (index = downstream.indexOfUpstream(this)) >= 0) {
            downstream.removeUpstream(index);
        }
    }

    @Override
    public DownstreamComponent getDownstream() {
        return this.downstream;
    }

    @Override
    public DownstreamComponent getDownstream(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Only " + this.nDownstream + " downstream layers available from " + this.name + "; cannot get layer " + index);
        }
        return this.downstream;
    }

    @Override
    public CopySourceLayer getDownstreamCopyLayer() {
        return this.downstreamCopyLayer;
    }

    @Override
    public int getIndexInDownstream() {
        return this.myIndexInDownstream;
    }

    @Override
    public int getIndexInDownstream(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Only " + this.nDownstream + " downstream layers available from " + this.name + "; cannot get layer " + index);
        }
        return this.myIndexInDownstream;
    }

    @Override
    public int indexOfDownstream(DownstreamComponent downstream) {
        return this.downstream == downstream ? 0 : -1;
    }

    @Override
    public int nDownstream() {
        return this.nDownstream;
    }

    @Override
    public boolean optimize() {
        if (this.downstream == null) {
            throw new IllegalStateException("No downstream layer set for " + this.name);
        }
        return true;
    }

    @Override
    public void removeDownstream(DownstreamComponent downstream) {
        if (this.downstream != downstream) {
            throw new IllegalArgumentException(downstream.getName() + " is not present in downstream layers of " + this.name);
        }
        DownstreamLayer old = this.downstream;
        this.downstream = null;
        this.nDownstream = 0;
        this.disconnectDownstream(old);
    }

    @Override
    public void removeDownstream(int index) {
        if (index >= this.nDownstream) {
            throw new IndexOutOfBoundsException("Only " + this.nDownstream + " downstream layers available from " + this.name + "; cannot remove layer " + index);
        }
        DownstreamLayer old = this.downstream;
        this.downstream = null;
        this.nDownstream = 0;
        this.disconnectDownstream(old);
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showConnectivity()) {
            sb.appendln("Downstream: " + this.downstream.getName());
        }
        if (sb.showExtra() && this.downstreamCopyLayer != null) {
            sb.appendln("DownstreamCopyLayer: " + this.downstreamCopyLayer.getName());
        }
        sb.popIndent();
    }
}

