/*
 * Decompiled with CFR 0.152.
 */
package zezinho.virtualGuns;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import zezinho.virtualGuns.Averager;
import zezinho.virtualGuns.VirtualBullet;

public class VirtualGun {
    public static double botX;
    public static double botY;
    private static Rectangle2D.Double fieldRect;
    private Vector activeBullets = new Vector();
    private Averager average = new Averager(historyDepth);
    private static int historyDepth;
    private static int numShots;

    public double calcTargetAngle(double power) {
        return 0.0;
    }

    public static void initialize(int historyDepth, double fieldWidth, double fieldHeight) {
        VirtualGun.historyDepth = historyDepth;
        fieldRect = new Rectangle2D.Double(0.0, 0.0, fieldWidth, fieldHeight);
    }

    public void fire(double power) {
        this.activeBullets.add(new VirtualBullet(this.calcTargetAngle(power), power, botX, botY));
        ++numShots;
    }

    public void fire(double power, double angle) {
        this.activeBullets.add(new VirtualBullet(angle, power, botX, botY));
        ++numShots;
    }

    public void nextTurn(Rectangle2D.Double rect, double inX, double inY) {
        botX = inX;
        botY = inY;
        for (int i = this.activeBullets.size() - 1; i >= 0; --i) {
            VirtualBullet currBullet = (VirtualBullet)this.activeBullets.get(i);
            currBullet.update();
            if (rect.contains(currBullet.getPosition())) {
                this.average.addEntry(1.0);
                currBullet.setVictim("hit");
            } else {
                if (fieldRect.contains(currBullet.getPosition())) continue;
                this.average.addEntry(0.0);
                currBullet.setInactive();
            }
            this.activeBullets.remove(i);
        }
    }

    public Vector getActiveBullets() {
        return this.activeBullets;
    }

    public static int getNumShots() {
        return numShots;
    }

    public static int getHistoryDepth() {
        return historyDepth;
    }

    public double getHitRate() {
        return this.average.recentAverage();
    }

    static {
        numShots = 0;
    }
}

