/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import xander.core.log.Logger;
import xander.core.paint.GraphPainter;

public class CPUUtilizationPainter
extends GraphPainter {
    private long startTurnTime;

    public CPUUtilizationPainter(Rectangle2D.Double battleFieldSize, int numDataPoints) {
        super(Color.GREEN, numDataPoints);
        double x = battleFieldSize.getMinX() + 10.0;
        double y = battleFieldSize.getMaxY() - 180.0;
        this.setPosition(x, y);
    }

    public void onTurnBegin() {
        this.startTurnTime = System.nanoTime();
    }

    public void onTurnEnd() {
        long turnTime = System.nanoTime() - this.startTurnTime;
        this.setRolledDataPoint((double)turnTime / 1000000.0);
        this.rollStartIndex();
    }

    @Override
    protected String getPointLabel(double value) {
        return String.valueOf(Logger.format(value, 2)) + " ms";
    }
}

