/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.debug.GraphicalDebugger;
import pedersen.debug.RenderableLineSegment;
import pedersen.debug.profiling.Stopwatches;
import pedersen.divination.WaveInboundBank;
import pedersen.misc.Metrics;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.Projection;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.grail.GridSector;
import pedersen.tactics.grail.GridSeekingProjection;
import pedersen.tactics.movement.MovementMethodBase;

public class MovementMethodGridImpl
extends MovementMethodBase {
    private static boolean isDebugMode = false;
    private static List renderableLineSegments = new ArrayList();
    private static List renderableRings = new ArrayList();
    private static GridSector gridSector = null;
    private long inboundWaveCount = 0L;
    private StaticPosition renderableLineSegmentStartPosition = null;
    private StaticPosition renderableLineSegmentEndPosition = null;

    public MovementMethodGridImpl() {
        super(23);
        this.exclusive = true;
    }

    public StaticPosition getRelativePositionTarget(Snapshot position, Snapshot target, long time) {
        DynamicPositionImpl vectorSum = new DynamicPositionImpl();
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].start();
        this.accountForAllWaves(position, target, time);
        if (gridSector != null) {
            StaticPosition destination = gridSector.getCenter();
            double velocity = position.getDistance(destination);
            velocity = velocity <= 6.0 ? (velocity -= 2.0) : (velocity <= 12.0 ? (velocity -= 6.0) : (velocity < 20.0 ? (velocity -= 12.0) : 8.0));
            StaticVectorImpl vector = new StaticVectorImpl(position.getBearing(destination), velocity);
            if (vector != null) {
                vectorSum.add(vector);
            }
        }
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].stop();
        return vectorSum.getStaticPosition();
    }

    private void accountForAllWaves(Snapshot position, StaticPosition target, long time) {
        if (Metrics.getInboundWaveCount() > this.inboundWaveCount) {
            this.inboundWaveCount = Metrics.getInboundWaveCount();
            List eligibleSectors = this.getEligibleSectors();
            if ((eligibleSectors = this.alternate(position, eligibleSectors, time)).size() > 0) {
                int value = (int)(Math.random() * (double)eligibleSectors.size());
                gridSector = (GridSector)eligibleSectors.get(value);
            }
        }
    }

    private List getEligibleSectors() {
        GridSector ring4;
        GridSector ring3;
        GridSector ring2;
        ArrayList<GridSector> eligibleSectors = new ArrayList<GridSector>();
        GridSector ring0 = gridSector;
        eligibleSectors.add(ring0);
        GridSector ring1 = ring0.getNorth();
        if (ring1.isInBounds()) {
            eligibleSectors.add(ring1);
            ring2 = ring1.getNorth();
            if (ring2.isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getNorth();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNorth();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                    if ((ring4 = ring3.getNortheast()).isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
                if ((ring3 = ring2.getNortheast()).isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNortheast();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
            if ((ring2 = ring1.getNortheast()).isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getNortheast();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNortheast();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
        }
        if ((ring1 = ring0.getNortheast()).isInBounds()) {
            eligibleSectors.add(ring1);
            ring2 = ring1.getNortheast();
            if (ring2.isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getNortheast();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNortheast();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                    if ((ring4 = ring3.getSoutheast()).isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
                if ((ring3 = ring2.getSoutheast()).isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSoutheast();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
            if ((ring2 = ring1.getSoutheast()).isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getSoutheast();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSoutheast();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
        }
        if ((ring1 = ring0.getSoutheast()).isInBounds()) {
            eligibleSectors.add(ring1);
            ring2 = ring1.getSoutheast();
            if (ring2.isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getSoutheast();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSoutheast();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                    if ((ring4 = ring3.getSouth()).isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
                if ((ring3 = ring2.getSouth()).isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSouth();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
            if ((ring2 = ring1.getSouth()).isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getSouth();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSouth();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
        }
        if ((ring1 = ring0.getSouth()).isInBounds()) {
            eligibleSectors.add(ring1);
            ring2 = ring1.getSouth();
            if (ring2.isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getSouth();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSouth();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                    if ((ring4 = ring3.getSouthwest()).isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
                if ((ring3 = ring2.getSouthwest()).isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSouthwest();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
            if ((ring2 = ring1.getSouthwest()).isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getSouthwest();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSouthwest();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
        }
        if ((ring1 = ring0.getSouthwest()).isInBounds()) {
            eligibleSectors.add(ring1);
            ring2 = ring1.getSouthwest();
            if (ring2.isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getSouthwest();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getSouthwest();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                    if ((ring4 = ring3.getNorthwest()).isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
                if ((ring3 = ring2.getNorthwest()).isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNorthwest();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
            if ((ring2 = ring1.getNorthwest()).isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getNorthwest();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNorthwest();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
        }
        if ((ring1 = ring0.getNorthwest()).isInBounds()) {
            eligibleSectors.add(ring1);
            ring2 = ring1.getNorthwest();
            if (ring2.isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getNorthwest();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNorthwest();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                    if ((ring4 = ring3.getNorth()).isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
                if ((ring3 = ring2.getNorth()).isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNorth();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
            if ((ring2 = ring1.getNorth()).isInBounds()) {
                eligibleSectors.add(ring2);
                ring3 = ring2.getNorth();
                if (ring3.isInBounds()) {
                    eligibleSectors.add(ring3);
                    ring4 = ring3.getNorth();
                    if (ring4.isInBounds()) {
                        eligibleSectors.add(ring4);
                    }
                }
            }
        }
        return eligibleSectors;
    }

    private List alternate(Snapshot position, List eligibleSectors, long time) {
        if (isDebugMode) {
            renderableLineSegments.clear();
            renderableRings.clear();
        }
        List gridSeekingProjections = this.getInitialGridSeekingProjections(position, eligibleSectors);
        eligibleSectors = new ArrayList<GridSector>();
        Iterator gridSeekingProjectionsIterator = gridSeekingProjections.iterator();
        while (gridSeekingProjectionsIterator.hasNext()) {
            GridSeekingProjection gridSeekingProjection = (GridSeekingProjection)gridSeekingProjectionsIterator.next();
            boolean isHit = false;
            int i = 0;
            while (!isHit && i < 100) {
                if (WaveInboundBank.singleton.isHit(gridSeekingProjection.getStaticPosition(), time + (long)i)) {
                    isHit = true;
                }
                StaticVector relativeVector = this.emulateMovement(gridSeekingProjection, gridSeekingProjection.getTargetGridSector().getCenter());
                gridSeekingProjection.setRelativeTargetHeading(relativeVector.getHeading());
                gridSeekingProjection.setRelativeTargetVelocity(relativeVector.getVelocity());
                if (isDebugMode) {
                    this.renderableLineSegmentStartPosition = gridSeekingProjection.getStaticPosition();
                }
                gridSeekingProjection.project();
                if (isDebugMode) {
                    this.renderableLineSegmentEndPosition = gridSeekingProjection.getStaticPosition();
                    renderableLineSegments.add(new RenderableLineSegment(this.renderableLineSegmentStartPosition, this.renderableLineSegmentEndPosition, Color.GREEN));
                }
                ++i;
            }
            if (isHit) continue;
            eligibleSectors.add(gridSeekingProjection.getTargetGridSector());
            renderableRings.add(gridSeekingProjection.getTargetGridSector().getCenter());
        }
        return eligibleSectors;
    }

    private List getInitialGridSeekingProjections(Snapshot position, List eligibleSectors) {
        ArrayList<GridSeekingProjection> gridSeekingProjections = new ArrayList<GridSeekingProjection>();
        Iterator iterator = eligibleSectors.iterator();
        while (iterator.hasNext()) {
            gridSeekingProjections.add(new GridSeekingProjection(position, (GridSector)iterator.next()));
        }
        return gridSeekingProjections;
    }

    public StaticVector emulateMovement(Projection position, StaticPosition destination) {
        DynamicPositionImpl compositePosition = new DynamicPositionImpl();
        double velocity = position.getDistance(destination);
        velocity = velocity <= 6.0 ? (velocity -= 2.0) : (velocity <= 12.0 ? (velocity -= 6.0) : (velocity < 20.0 ? (velocity -= 12.0) : 8.0));
        compositePosition.add(new StaticVectorImpl(position.getBearing(destination), velocity));
        StaticVector movementVector = compositePosition.getVector();
        movementVector = this.adjustForAnglesToRear(position.getHeading(), position.getVelocity(), movementVector.getHeading(), movementVector.getVelocity());
        return movementVector;
    }

    private StaticVector adjustForAnglesToRear(double presentHeading, double presentVelocity, double movementHeading, double movementVelocity) {
        double totalRelativeHeadingChange = Constraints.getNegativePiToPi(movementHeading - presentHeading);
        if (Math.abs(totalRelativeHeadingChange) > 1.5707963267948966) {
            movementHeading += Math.PI;
            movementVelocity = -movementVelocity;
        }
        return new StaticVectorImpl(presentHeading, presentVelocity).compareVector(new StaticVectorImpl(movementHeading, movementVelocity));
    }

    public static void setGridSector(GridSector newGridSector) {
        gridSector = newGridSector;
    }

    public static void onPaint(Graphics2D console) {
        isDebugMode = true;
        console.setColor(Color.orange);
        GraphicalDebugger.singleton.drawRings(console, renderableRings, GridSector.radius);
        console.setColor(Color.blue);
        GraphicalDebugger.singleton.drawRing(console, gridSector.getCenter(), GridSector.radius);
    }
}

