/*
 * Decompiled with CFR 0.152.
 */
package Krabb;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class Vector2D
implements Serializable {
    double x;
    double y;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D Add(Vector2D v) {
        Vector2D w = new Vector2D(this);
        w.x += v.x;
        w.y += v.y;
        return w;
    }

    public Vector2D Subtract(Vector2D v) {
        Vector2D w = new Vector2D(this);
        w.x -= v.x;
        w.y -= v.y;
        return w;
    }

    public double Dot(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public Vector2D Multiplicate(double a) {
        Vector2D w = new Vector2D(this);
        w.x *= a;
        w.y *= a;
        return w;
    }

    public double Length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getA() {
        return 1.5707963267948966 - Math.atan2(this.y, this.x);
    }

    public void Normalize() {
        double l = this.Length();
        if (l == 0.0) {
            this.x = 0.0;
            this.y = 0.0;
            return;
        }
        this.x /= l;
        this.y /= l;
    }

    public Vector2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector2D(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2D(Point2D p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Vector2D(double a, double l) {
        this.x = Math.sin(a) * l;
        this.y = Math.cos(a) * l;
    }
}

