/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import nosteel.Basics.Vector;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.FiredBullet;
import nosteel.Modules.Data.ScanData;
import robocode.Bullet;
import robocode.ScannedRobotEvent;

public class DataList {
    public static boolean FRONT_OF_LIST = true;
    public static boolean END_OF_LIST = false;
    List<EnemyData> enemies = new ArrayList<EnemyData>();

    public void intiEnemyArray(int nrOfEnemies) {
        for (int i = 0; i < nrOfEnemies; ++i) {
            this.enemies.add(new EnemyData());
        }
    }

    public EnemyData getEnemyData(String name) {
        for (EnemyData e : this.enemies) {
            if (!e.isEnemy(name)) continue;
            return e;
        }
        return null;
    }

    private EnemyData addEnemy(String name) {
        for (EnemyData e : this.enemies) {
            if (e.isDetected()) continue;
            e.enemyDetected(name);
            return e;
        }
        return null;
    }

    public void addScan(ScannedRobotEvent event, Vector myPos, double myHeadingRad, long time) {
        EnemyData e = this.getEnemyData(event.getName());
        if (e == null) {
            e = this.addEnemy(event.getName());
        }
        if (e != null) {
            e.addScan(event, myPos, myHeadingRad, time);
        }
    }

    public int getNrOfEnemiesTotal() {
        return this.enemies.size();
    }

    public int getNrOfEnemiesAlive() {
        int alive = 0;
        for (EnemyData e : this.enemies) {
            if (!e.isAlive() && e.isDetected()) continue;
            ++alive;
        }
        return alive;
    }

    public EnemyData getEnemyIndexed(int index) {
        return this.enemies.get(index);
    }

    public ListIterator<EnemyData> getEnemyListIterator(boolean pos) {
        return this.enemies.listIterator(pos == FRONT_OF_LIST ? 0 : this.enemies.size());
    }

    public void setEnemyKilled(String name) {
        EnemyData e = this.getEnemyData(name);
        if (e != null) {
            e.setDead();
        }
    }

    public int getNumOfDiscoveredEnemies() {
        int count = 0;
        for (EnemyData e : this.enemies) {
            if (!e.isDetected()) continue;
            ++count;
        }
        return count;
    }

    public void draw(Graphics2D g, String name) {
        g.setColor(Color.YELLOW);
        EnemyData e = this.getEnemyData(name);
        if (e != null) {
            e.drawScans(g);
        }
    }

    public EnemyData getMostRecentScan() {
        long lastestTime = 0L;
        EnemyData mostRecent = null;
        for (EnemyData e : this.enemies) {
            ScanData last = e.getLastScan();
            if (last == null || lastestTime >= last.time) continue;
            lastestTime = last.time;
            mostRecent = e;
        }
        return mostRecent;
    }

    public FiredBullet getFiredBullet(Bullet b) {
        EnemyData e;
        FiredBullet found = null;
        Iterator<EnemyData> iterator = this.enemies.iterator();
        while (iterator.hasNext() && (found = (e = iterator.next()).getFiredBullet(b)) == null) {
        }
        return found;
    }

    public ScanData getScan(String target, int index) {
        ScanData s = null;
        EnemyData e = this.getEnemyData(target);
        if (e != null) {
            s = e.getScanByIndex(index);
        }
        return s;
    }
}

