/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.DataList;
import nosteel.Modules.Stats.AnalyseMovementLinearity;
import nosteel.Modules.Stats.AnalyseMovementSitting;
import nosteel.Modules.Stats.BulletHitRate;
import nosteel.Modules.Stats.Statistic;

public class Statistics {
    private DataList scans;
    private Aiming aiming;
    private Vector battleSize;
    public static int INDEX_AnalyseMovementLinearity = 0;
    public static int INDEX_BulletHitRate = 1;
    public static int INDEX_AnalyseMovementSitting = 2;
    List<Statistic> list;

    public Statistics(DataList scans_, Aiming aim) {
        this.aiming = aim;
        this.scans = scans_;
        this.list = new ArrayList<Statistic>();
        this.list.add(new AnalyseMovementLinearity(scans_, aim));
        this.list.add(new BulletHitRate(scans_, aim));
        this.list.add(new AnalyseMovementSitting(scans_, aim));
    }

    public void setBattlefieldSize(Vector size) {
        this.battleSize = size;
        for (Statistic e : this.list) {
            e.setBattlefieldSize(size);
        }
    }

    public void analyseAll() {
        for (Statistic e : this.list) {
            e.analyse();
        }
    }

    public void analyseIndexed(int id) {
        Statistic e = this.list.get(id);
        e.analyse();
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.GREEN);
        for (Statistic e : this.list) {
            e.draw(g);
        }
    }

    public void print() {
        for (Statistic e : this.list) {
            e.print();
        }
    }

    public void openCSV() {
        for (Statistic e : this.list) {
            e.openCSV();
        }
    }

    public void printCsvRow(int round) {
        for (Statistic e : this.list) {
            e.printCsvRow(round);
        }
    }

    public Statistic getStatsByIndex(int id) {
        return this.list.get(id);
    }
}

