/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.ram;

import xander.cat.group.ram.AntiRamScenario;
import xander.cat.group.ram.RamDrive;
import xander.cat.group.ram.RamEscapeDrive;
import xander.cat.group.ram.RamGun;
import xander.cat.group.ram.RamLowEnergyScenario;
import xander.cat.group.rem.REMFactory;
import xander.core.ComponentChain;
import xander.core.gun.XanderGun;
import xander.core.gun.power.FixedPowerSelector;
import xander.core.gun.power.PowerSelector;
import xander.core.gun.targeter.LinearTargeter;

public class RamFactory {
    public static final double DEFAULT_ENGAGE_DISTANCE = 70.0;
    public static final double DEFAULT_DISENGAGE_DISTANCE = 120.0;

    public static void addAntiRamComponents(ComponentChain chain) {
        RamEscapeDrive ramEscapeDrive = new RamEscapeDrive();
        PowerSelector ramEscapePowerSelector = new FixedPowerSelector(3.0);
        ramEscapePowerSelector = REMFactory.getX5PowerSelector(ramEscapePowerSelector);
        LinearTargeter ramEscapeTargeter = new LinearTargeter();
        XanderGun ramEscapeGun = new XanderGun(ramEscapeTargeter, ramEscapePowerSelector);
        AntiRamScenario antiRamScenario = new AntiRamScenario(ramEscapeDrive.getName(), 70.0, 120.0);
        chain.addComponents(antiRamScenario, ramEscapeDrive, ramEscapeGun);
    }

    public static void addRamComponents(ComponentChain chain, double opponentEnergy, double fallbackOpponentEnergy, int ticksSinceNoWaves) {
        RamLowEnergyScenario scenario = new RamLowEnergyScenario(opponentEnergy, ticksSinceNoWaves);
        scenario.setFallbackOpponentEnergy(fallbackOpponentEnergy);
        RamDrive ramDrive = new RamDrive();
        RamGun ramGun = new RamGun();
        chain.addComponents(scenario, ramDrive, ramGun);
    }
}

