/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import xander.core.paint.GraphData;

public class CPUUtilizationGraphData
extends GraphData {
    public static final String PAINTER_NAME = "CPU Utilization";
    private long startTurnTime;
    private List<GraphData.HorizontalRule> horizontalRules;

    public CPUUtilizationGraphData(int numDataPoints) {
        super(PAINTER_NAME, numDataPoints);
    }

    @Override
    public String getYAxisLabel() {
        return "ms";
    }

    @Override
    public String getXAxisLabel() {
        return "Time";
    }

    @Override
    public List<GraphData.HorizontalRule> getHorizontalRules() {
        return this.horizontalRules;
    }

    private void addRule(double y, Color color, String description) {
        if (this.horizontalRules == null) {
            this.horizontalRules = new ArrayList<GraphData.HorizontalRule>();
        }
        this.horizontalRules.add(new GraphData.HorizontalRule(y, color, description));
    }

    public void setCPUConstant(double CPUConstant) {
        this.addRule(CPUConstant, Color.RED, "CPU Constant");
    }

    public void onTurnBegin() {
        this.startTurnTime = System.nanoTime();
    }

    public void onTurnEnd() {
        long turnTime = System.nanoTime() - this.startTurnTime;
        this.rollStartIndex();
        this.setRolledDataPoint((double)turnTime / 1000000.0);
    }
}

