/*
 * Decompiled with CFR 0.152.
 */
package yarhoslav;

import java.util.Map;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import yarhoslav.Enemigo;

public class Radar {
    private final Map mContexto;
    private double mDir;
    private long mTurno;
    private boolean mEnemigoDetectado;

    public Radar(Map pContexto) {
        this.mContexto = pContexto;
        this.mEnemigoDetectado = false;
    }

    public void onTick(long pTurno) {
        this.mTurno = pTurno;
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        this.mDir = lRobot.getRadarHeading();
        this.mEnemigoDetectado = false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.mEnemigoDetectado = true;
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        this.mDir = lRobot.getRadarHeading();
        Enemigo lEnemigo = (Enemigo)this.mContexto.get("ENEMIGO");
        lEnemigo.onScannedRobot(e);
    }

    public void ejecutar() {
        double lDelta;
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        if (this.mEnemigoDetectado) {
            Enemigo lEnemigo = (Enemigo)this.mContexto.get("ENEMIGO");
            lDelta = lRobot.getHeading() - this.mDir + lEnemigo.getDelta();
            lDelta = lDelta < 0.0 ? Utils.normalRelativeAngleDegrees((double)(lDelta - 22.5)) : Utils.normalRelativeAngleDegrees((double)(lDelta + 22.5));
        } else {
            lDelta = 45.0;
        }
        lRobot.out.println("RADAR: DELTA:" + lDelta + " Enemigo Detectado:" + this.mEnemigoDetectado);
        lRobot.setTurnRadarRight(lDelta);
    }
}

