/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Heading;
import shrub.Location;
import shrub.QuadrantAdjust;

public class LinearPredictor {
    public final double InterceptSpeed(double minSpeedAllowed, double maxSpeedAllowed, Location subLocn, Heading subHdng, Location objLocn, Heading objHdng, double objVelocity) {
        double distanceToObj = 0.0;
        double subSpeed = 0.0;
        Heading hdngToObj = new Heading();
        Bearing offsetRot = new Bearing();
        Heading adjSubHdng = new Heading();
        Heading adjObjHdng = new Heading();
        double objSpeed = 0.0;
        double subDegThetaY = 0.0;
        double objDegThetaY = 0.0;
        double subRadThetaY = 0.0;
        double objRadThetaY = 0.0;
        double subSenseX = 0.0;
        double objSenseX = 0.0;
        double subSenseY = 0.0;
        double objSenseY = 0.0;
        double objSpeedX = 0.0;
        double subVelocityY = 0.0;
        double objVelocityY = 0.0;
        double angularWidthObjRad = 0.0;
        double angularWidthObjDeg = 0.0;
        hdngToObj.SetFromTo(subLocn, objLocn);
        distanceToObj = subLocn.DistanceTo(objLocn);
        angularWidthObjRad = Math.atan(20.0 / distanceToObj);
        angularWidthObjDeg = Math.toDegrees(angularWidthObjRad);
        offsetRot.Set(-1.0 * hdngToObj.Get());
        adjSubHdng.Set(subHdng);
        adjObjHdng.Set(objHdng);
        adjSubHdng.Adjust(offsetRot);
        adjObjHdng.Adjust(offsetRot);
        if (objVelocity < 0.0) {
            objSpeed = Math.abs(objVelocity);
            adjObjHdng.Flip();
        } else {
            objSpeed = objVelocity;
        }
        QuadrantAdjust qAdjSub = new QuadrantAdjust(adjSubHdng.Get());
        subDegThetaY = qAdjSub.GetAdjThetaDegY();
        subSenseX = qAdjSub.GetAdjSenseX();
        subSenseY = qAdjSub.GetAdjSenseY();
        QuadrantAdjust qAdjObj = new QuadrantAdjust(adjObjHdng.Get());
        objDegThetaY = qAdjObj.GetAdjThetaDegY();
        objSenseX = qAdjObj.GetAdjSenseX();
        objSenseY = qAdjObj.GetAdjSenseY();
        objRadThetaY = Math.toRadians(objDegThetaY);
        objSpeedX = objSpeed * Math.sin(objRadThetaY);
        if (objSpeedX < 1.1 && subDegThetaY <= angularWidthObjDeg) {
            subSpeed = minSpeedAllowed;
        } else if (objSenseX * subSenseX < 0.0) {
            subSpeed = -1.0;
        } else {
            subRadThetaY = Math.toRadians(subDegThetaY);
            subSpeed = objSpeedX / Math.sin(subRadThetaY);
            if (subSpeed < minSpeedAllowed || subSpeed > maxSpeedAllowed) {
                subSpeed = -1.0;
            } else {
                subVelocityY = subSpeed * Math.cos(subRadThetaY) * subSenseY;
                if (subVelocityY < (objVelocityY = objSpeed * Math.cos(objRadThetaY) * objSenseY)) {
                    subSpeed = -1.0;
                }
            }
        }
        return subSpeed;
    }
}

