/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import metal.shared.MAimSegment;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MMath;
import metal.shared.MPoint;
import metal.shared.MPolar;
import metal.shared.MProbability;

public class MAim {
    public static double angle = 0.0;
    public static double dir;
    public static MPoint enemy;
    public static boolean fire;
    public static double heading;
    public static double time;

    static {
        time = 0.0;
        dir = 1.0;
        fire = false;
        enemy = null;
    }

    static class Linear {
        Linear() {
        }

        public static double getAngelMaxSpeed(double index) {
            double t = MBullet.getTime();
            double coolTime = (1.0 + MBullet.power / 5.0) / MBotData.self.getGunCoolingRate();
            if ((double)MBotData.self.getTime() + t - (double)MBotData.enemy.timeMax - (double)MBotData.enemy.timeMaxPeriod < 0.0) {
                Linear.getAngleMaxFlag(1.0, coolTime);
                Linear.getAngleDesFlag(1.0);
                Linear.getAngleAccFlag(-1.0);
                Linear.getAngleMaxFlag(-1.0, t - (time += coolTime));
                t = MBotData.getLocation().distance(enemy) / MBullet.getSpeed();
                angle = Linear.getAngleMax(coolTime, t) * (index / MProbability.NO);
                angle += Linear.getAngleDes(t);
                angle -= Linear.getAngleAcc(t);
                MBotData.test("angle lin cons and des 2 " + (angle -= Linear.getAngleMax(t - time, t) * (index / MProbability.NO)));
            } else {
                double i = MBotData.enemy.getDirection() * (index - MProbability.HALF) / MProbability.HALF;
                if (i == 0.0) {
                    i = 1.0;
                }
                enemy = MBotData.enemy;
                t = MBotData.getLocation().distance(enemy) / MBullet.getSpeed();
                enemy = MAimSegment.Con.getLocation(enemy, coolTime, MMath.sign(i), i);
                MBotData.test("angle lin cons and des 3 en1 " + enemy);
                time += coolTime;
                enemy = MAimSegment.Des.getLocation(enemy, 8.0 * MMath.sign(i), MMath.sign(i));
                MBotData.test("angle lin cons and des 3 en2 " + enemy);
                time += MAimSegment.Des.time;
                enemy = MAimSegment.Acc.getLocation(enemy, 0.0, -MMath.sign(i));
                MBotData.test("angle lin cons and des 3 en3 " + enemy);
                enemy = MAimSegment.Con.getLocation(enemy, t - (time += MAimSegment.Acc.time), -MMath.sign(i), i);
                angle = MAngle.relative(MAngle.absolute(MBotData.getLocation(), enemy) - MBotData.self.getGunHeading());
                MBotData.test("angle lin cons and des 3 " + angle);
            }
            return angle;
        }

        public static double getAngle(double index) {
            double i = 1.0 / MProbability.HALF * (index - MProbability.HALF);
            angle = 0.0;
            double t = MBullet.getTime();
            heading = MBotData.enemy.heading;
            double bearing = MBotData.enemy.bearing;
            time = 0.0;
            double accDiff = Math.round(-Math.abs(MBotData.enemy.speedLast) + Math.abs(MBotData.enemy.speed));
            enemy = MBotData.enemy;
            t = MBotData.getLocation().distance(enemy) / MBullet.getSpeed();
            if (accDiff == 0.0) {
                if (Math.abs(MBotData.enemy.headingDiff) > 1.0 && Math.abs(MBotData.enemy.speed) > 3.5) {
                    t = MBotData.getLocation().distance(enemy) / MBullet.getSpeed();
                    angle = Linear.getAngleMax(1.0, 1.0) * i;
                } else if (Math.abs(MBotData.enemy.headingDiff) < 1.0 && Math.abs(MBotData.enemy.speed) > 7.0) {
                    angle = MAngle.max(MBotData.enemy.speedLat, MBullet.getSpeed()) * i * MBotData.enemy.getDirection();
                    MBotData.test("angle stat1 " + angle);
                } else {
                    enemy = MAimSegment.Con.getLocation(enemy, t - time, 1.0, i);
                    angle = MAngle.relative(MAngle.absolute(MBotData.getLocation(), enemy) - MBotData.self.getGunHeading());
                    MBotData.test("angle lin " + angle);
                }
            } else if (accDiff < 0.0) {
                enemy = MAimSegment.Des.getLocation(enemy, 1.0, i);
                time = MAimSegment.Des.time;
                enemy = MAimSegment.Acc.getLocation(enemy, 0.0, -1.0);
                enemy = MAimSegment.Con.getLocation(enemy, t - (time += MAimSegment.Acc.time), -1.0, i);
                angle = MAngle.relative(MAngle.absolute(MBotData.getLocation(), enemy) - MBotData.self.getGunHeading());
                MBotData.test("des ");
            } else {
                enemy = MAimSegment.Acc.getLocation(enemy, 1.0, i);
                time = MAimSegment.Acc.time;
                enemy = MAimSegment.Con.getLocation(enemy, t - time, -1.0, i);
                angle = MAngle.relative(MAngle.absolute(MBotData.getLocation(), enemy) - MBotData.self.getGunHeading());
                MBotData.test("acc");
            }
            double turn = MAngle.relative(bearing - angle - MBotData.self.getGunHeading());
            return turn;
        }

        public static double getAngle2(double index) {
            double angle1 = MAngle.max(8.0, MBullet.getSpeed()) / MProbability.HALF * MBotData.enemy.getDirection() * (index - MProbability.HALF);
            MPoint p = MPolar.getPoint(MBotData.getLocation(), MAngle.relative(MBotData.enemy.bearing + angle1), MBotData.enemy.distance * MMath.sign(MBotData.enemy.speed));
            angle = MAngle.relative(MBotData.enemy.bearing + angle1 - MBotData.self.getGunHeading());
            if (Math.abs(angle) > 20.0) {
                angle = MAngle.relative(MBotData.enemy.bearing - MBotData.self.getGunHeading());
            }
            return angle;
        }

        public static double getAngle6(double index) {
            double i = MBotData.enemy.getDirection() / MProbability.HALF * (index - MProbability.HALF);
            angle = MAngle.max(8.0, MBullet.getSpeed()) / MProbability.HALF * (index - MProbability.HALF);
            double turn = MBotData.enemy.bearing - MBotData.self.getGunHeading();
            return MAngle.relative(turn += angle);
        }

        public static double getAngleAcc(double timeBul) {
            double t = 0.0;
            t = 8.0 - Math.abs(Math.rint(MBotData.enemy.speed));
            double turn = MAngle.max(t / 2.0, MBullet.getSpeed()) * (t / timeBul);
            return turn;
        }

        public static void getAngleAccFlag(double flag) {
            double t = 0.0;
            t = 8.0 - Math.abs(Math.rint(MBotData.enemy.speed));
            enemy = enemy.getPoint(heading += MBotData.enemy.headingDiff * t, t / 2.0, t * MMath.sign(MBotData.enemy.speed) * flag);
            time += t;
        }

        public static double getAngleDes(double timeBul) {
            double t = Math.abs(Math.rint(MBotData.enemy.speed)) / 2.0;
            double turn = MAngle.max(t, MBullet.getSpeed()) * (t / timeBul);
            return turn;
        }

        public static void getAngleDesFlag(double flag) {
            double t = Math.abs(Math.rint(MBotData.enemy.speed)) / 2.0;
            enemy = enemy.getPoint(heading += MBotData.enemy.headingDiff * t, t / 2.0, t * MMath.sign(MBotData.enemy.speed) * flag);
            time += t;
        }

        public static double getAngleMax(double consTime, double timeBul) {
            double speed = 8.0 * MMath.sign(MBotData.enemy.speed);
            double turn = MAngle.max(speed, MBullet.getSpeed()) * (consTime / timeBul);
            return turn;
        }

        public static void getAngleMaxFlag(double flag, double consTime) {
            double speed = 0.0;
            speed = 8.0;
            enemy = MPolar.getPoint(enemy, MBotData.enemy.bearing - (heading += MBotData.enemy.headingDiff > 2.0 ? MBotData.enemy.headingDiff * 4.0 : MBotData.enemy.headingDiff * 4.0), MBotData.enemy.getDistanceAvg(consTime, 8.0 * MMath.sign(MBotData.enemy.speed) * flag));
        }

        public static double getAngleMaxHead(double consTime) {
            double speed = 0.0;
            speed = 8.0;
            heading = MBotData.enemy.heading + (MBotData.enemy.headingDiff > 5.0 ? MBotData.enemy.headingDiff * 4.0 : MBotData.enemy.headingDiff * 4.0);
            enemy = MPolar.getPoint(MBotData.enemy, heading, consTime * MBotData.enemy.getSpeedAvg());
            return MAngle.relative(MAngle.absolute(MBotData.getLocation(), enemy) - MBotData.enemy.bearing);
        }
    }

    static class Direct {
        Direct() {
        }

        public static double getAngle() {
            return MAngle.relative(MBotData.enemy.bearing - MBotData.self.getGunHeading());
        }
    }
}

