/*
 * Decompiled with CFR 0.152.
 */
package ds.gun;

import ds.Hud;
import ds.Utils;
import ds.constant.ConstantManager;
import ds.gun.AbstractGun;
import ds.gun.BulletWave;
import ds.gun.FireSolution;
import ds.gun.VirtualBullet;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GunStats
implements Hud.Painter {
    private ArrayList<AbstractGun> m_guns;
    private HashMap<AbstractGun, Double> m_scores;
    private BulletWave m_lastWave;
    private ArrayList<BulletWave> m_waves;
    private IVirtualBot m_owner;
    private ITargetManager m_targetManager;
    private int m_rollingDepth;
    private AbstractGun m_currentBestGun = null;

    public GunStats(IVirtualBot owner, ITargetManager targetManager, ArrayList<AbstractGun> guns) {
        this.m_owner = owner;
        this.m_targetManager = targetManager;
        this.m_guns = guns;
        this.m_waves = new ArrayList();
        this.m_lastWave = null;
        this.m_scores = new HashMap();
        this.m_rollingDepth = (int)ConstantManager.getInstance().getIntegerConstant("gun.selector.statsDepth").longValue();
        for (AbstractGun gun : this.m_guns) {
            this.m_scores.put(gun, 0.0);
        }
    }

    public void virtualFire(AbstractGun gun, double power) throws TargetException {
        if (this.m_lastWave == null || this.m_lastWave.getDateTime().before(this.m_owner.getDateTime())) {
            this.m_lastWave = new BulletWave(this.m_owner.getDateTime().getRound(), this.m_owner.getDateTime().getTurn(), true);
            this.m_waves.add(this.m_lastWave);
        }
        Point2D.Double position = new Point2D.Double(this.m_owner.getX(), this.m_owner.getY());
        FireSolution fs = gun.getFireSolution(power);
        VirtualBullet vb = new VirtualBullet(this.m_targetManager.getCurrentTarget(), gun, position, fs.getAbsoluteAngle(), power);
        this.m_lastWave.addBullet(vb);
    }

    public AbstractGun getBestGun() {
        Double bestScore = -1.0;
        AbstractGun bestGun = null;
        for (AbstractGun gun : this.m_guns) {
            Double score = this.m_scores.get(gun);
            if (!(score >= bestScore)) continue;
            bestScore = score;
            bestGun = gun;
        }
        this.m_currentBestGun = bestGun;
        return bestGun;
    }

    public void update() {
        for (BulletWave wave : this.m_waves) {
            wave.update();
        }
        Iterator<BulletWave> itBW = this.m_waves.iterator();
        while (itBW.hasNext()) {
            BulletWave wave = itBW.next();
            try {
                VirtualBullet vb = wave.getBullets().get(0);
                if (!(vb.travelDistance() - 30.0 > vb.getStartPosition().distance(this.m_targetManager.getCurrentTarget().getPosition()))) continue;
                this.computeStats(wave);
                itBW.remove();
            }
            catch (TargetException e) {
                itBW.remove();
            }
            catch (IndexOutOfBoundsException e) {
                itBW.remove();
            }
        }
        for (BulletWave wave : this.m_waves) {
            for (VirtualBullet vb : wave.getBullets()) {
                try {
                    IVirtualBot target = this.m_targetManager.getCurrentTarget();
                    if (!(vb.getCurrentPosition().getX() >= target.getBottomLeftCorner().getX()) || !(vb.getCurrentPosition().getY() >= target.getBottomLeftCorner().getY()) || !(vb.getCurrentPosition().getX() <= target.getUpperRightCorner().getX()) || !(vb.getCurrentPosition().getY() <= target.getUpperRightCorner().getY())) continue;
                    vb.setHit(true);
                }
                catch (TargetException targetException) {
                    // empty catch block
                }
            }
        }
    }

    private void computeStats(BulletWave wave) {
        for (VirtualBullet vb : wave.getBullets()) {
            Double score;
            if (vb.hasHit()) {
                score = this.m_scores.get(vb.getFiringGun());
                score = Utils.rollingAvg(score, 1.0, this.m_rollingDepth, 1.0);
                this.m_scores.put(vb.getFiringGun(), score);
                continue;
            }
            score = this.m_scores.get(vb.getFiringGun());
            score = Utils.rollingAvg(score, 0.0, this.m_rollingDepth, 1.0);
            this.m_scores.put(vb.getFiringGun(), score);
        }
    }

    @Override
    public void paint(Hud hud, long tick) {
        int i = 0;
        for (BulletWave wave : this.m_waves) {
            int j = 0;
            hud.setColor(Color.lightGray);
            hud.drawString("wave " + i, 5.0, 5 + i * 10);
            for (VirtualBullet bullet : wave.getBullets()) {
                hud.setColor(bullet.getFiringGun().getColor());
                if (this.m_currentBestGun == bullet.getFiringGun()) {
                    hud.setColor(Color.red);
                }
                if (bullet.hasHit()) {
                    hud.setColor(Color.orange);
                }
                hud.drawString("[" + bullet.hasHit() + "]", 50 + j * 50, 5 + i * 10);
                hud.drawLine(bullet.getStartPosition().getX(), bullet.getStartPosition().getY(), bullet.getCurrentPosition().getX(), bullet.getCurrentPosition().getY());
                ++j;
            }
            ++i;
        }
        i = 0;
        for (AbstractGun gun : this.m_guns) {
            if (gun == this.m_currentBestGun) {
                hud.setColor(Color.green);
            } else {
                hud.setColor(Color.lightGray);
            }
            hud.drawString(String.valueOf(gun.getName()) + ":\t" + String.format("%.4f", this.m_scores.get(gun)), 400.0, 5 + i * 10);
            ++i;
        }
    }

    public double getScore(AbstractGun gun) {
        return this.m_scores.get(gun);
    }
}

